/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe;

import com.google.common.collect.Queues;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.TexturesResource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeCapabilityHolder;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeBuilder;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeSerializer;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.event.FuelRecipeUIEvent;
import com.lowdragmc.mbd2.api.recipe.event.RecipeUIEvent;
import com.lowdragmc.mbd2.api.recipe.event.TransferProxyRecipeEvent;
import com.lowdragmc.mbd2.integration.kubejs.recipe.MBDRecipeSchema;
import com.lowdragmc.mbd2.utils.FormattingUtil;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

@RemapPrefixForJS(value="kjs$")
public class MBDRecipeType
implements RecipeType<MBDRecipe>,
ITagSerializable<CompoundTag>,
IConfigurable {
    public static final MBDRecipeType DUMMY = new MBDRecipeType(MBD2.id("dummy"), new RecipeType[0]);
    @Configurable(name="recipe_type.registry_name", tips={"recipe_type.registry_name.tooltip", "config.require_restart"}, forceUpdate=false)
    private ResourceLocation registryName;
    private MBDRecipeBuilder recipeBuilder;
    @Configurable(name="recipe_type.icon", tips={"recipe_type.icon.tooltip"})
    private IGuiTexture icon = new ResourceTexture();
    @Configurable(name="recipe_type.fuel_icon", tips={"recipe_type.fuel_icon.tooltip"})
    private IGuiTexture fuelIcon = new ProgressTexture();
    @Configurable(name="recipe_type.require_fuel", tips={"recipe_type.require_fuel.tooltip"})
    protected boolean requireFuelForWorking;
    @Configurable(name="recipe_type.is_xei_visible", tips={"recipe_type.is_xei_visible.tooltip"})
    protected boolean isXEIVisible = true;
    @Configurable(name="recipe_type.is_proxy_recipe_xei_visible", tips={"recipe_type.is_proxy_recipe_xei_visible.tooltip"})
    protected boolean isProxyRecipeXEIVisible = false;
    private final List<RecipeType<?>> proxyRecipeTypes = new ArrayList();
    protected final Map<ResourceLocation, MBDRecipe> builtinRecipes = new LinkedHashMap<ResourceLocation, MBDRecipe>();
    protected UICreator uiCreator = UICreator.DEFAULT;
    protected Size uiSize = new Size(176, 166);
    protected UICreator fuelUICreator = UICreator.DEFAULT;
    protected Size fuelUISize = new Size(176, 166);
    @Nullable
    private File projectFile;
    @Deprecated
    protected final Map<RecipeType<?>, List<MBDRecipe>> proxyRecipes = new HashMap();

    public MBDRecipeType(ResourceLocation registryName, RecipeType<?> ... proxyRecipes) {
        this.registryName = registryName;
        this.recipeBuilder = new MBDRecipeBuilder(registryName, this);
        this.proxyRecipeTypes.addAll(Arrays.asList(proxyRecipes));
    }

    public void onRecipeManagerLoaded(Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> rawRecipes) {
        Map recipeTypeMap = rawRecipes.computeIfAbsent(this, type -> new HashMap());
        recipeTypeMap.putAll(this.builtinRecipes);
        this.proxyRecipes.clear();
        for (RecipeType<?> type2 : this.proxyRecipeTypes) {
            ArrayList<MBDRecipe> recipes = new ArrayList<MBDRecipe>();
            for (Map.Entry<ResourceLocation, Recipe<?>> recipe : rawRecipes.get(type2).entrySet()) {
                MBDRecipe mbdRecipe = this.toMBDrecipe(type2, recipe.getKey(), recipe.getValue());
                if (mbdRecipe == null) continue;
                recipes.add(mbdRecipe);
                recipeTypeMap.put(mbdRecipe.id, mbdRecipe);
            }
            this.proxyRecipes.put(type2, recipes);
        }
    }

    public void onRecipeManagerLoadedKjs(Map<ResourceLocation, Recipe<?>> recipesByName) {
        recipesByName.putAll(this.builtinRecipes);
        this.proxyRecipes.clear();
        HashSet proxyRecipeTypes = new HashSet(this.proxyRecipeTypes);
        if (proxyRecipeTypes.isEmpty()) {
            return;
        }
        for (Map.Entry<ResourceLocation, Recipe<?>> entry : recipesByName.entrySet()) {
            MBDRecipe mbdRecipe;
            ResourceLocation key = entry.getKey();
            MBDRecipe recipe = entry.getValue();
            if (!proxyRecipeTypes.contains(recipe.m_6671_()) || (mbdRecipe = this.toMBDrecipe(recipe.m_6671_(), key, recipe)) == null) continue;
            this.proxyRecipes.computeIfAbsent(recipe.m_6671_(), type -> new ArrayList()).add(mbdRecipe);
        }
        for (List list : this.proxyRecipes.values()) {
            for (MBDRecipe recipe : list) {
                recipesByName.put(recipe.m_6423_(), recipe);
            }
        }
    }

    public static MBDRecipeType createDefault() {
        return new MBDRecipeType(MBD2.id("recipe_type"), new RecipeType[0]);
    }

    public MBDRecipeType loadProductiveTag(@Nullable File file, CompoundTag tag, Deque<Runnable> postTask) {
        this.projectFile = file;
        this.registryName = new ResourceLocation(tag.m_128469_("recipe_type").m_128461_("registryName"));
        postTask.add(() -> {
            TexturesResource texturesResource = new TexturesResource();
            texturesResource.deserializeNBT(tag.m_128469_("resources").m_128469_("ldlib.gui.editor.group.textures"));
            UIResourceTexture.setCurrentResource((Resource)texturesResource, (boolean)false);
            this.deserializeNBT(tag.m_128469_("recipe_type"));
            UIResourceTexture.clearCurrentResource();
            CompoundTag uiTag = tag.m_128469_("ui");
            CompoundTag size = uiTag.m_128469_("size");
            this.setUiSize(new Size(size.m_128451_("width"), size.m_128451_("height")));
            this.setUiCreator(recipe -> {
                WidgetGroup recipeUI = new WidgetGroup();
                recipeUI.setClientSideWidget();
                IConfigurableWidget.deserializeNBT((IConfigurableWidget)recipeUI, (CompoundTag)uiTag, (Resource)texturesResource, (boolean)false);
                this.bindXEIRecipeUI(recipeUI, recipe);
                recipeUI.setSelfPosition(0, 0);
                recipeUI.setBackground(new IGuiTexture[]{IGuiTexture.EMPTY});
                return recipeUI;
            });
            if (this.requireFuelForWorking && tag.m_128441_("fuelUI")) {
                CompoundTag fuelUITag = tag.m_128469_("fuelUI");
                CompoundTag fuelSize = fuelUITag.m_128469_("size");
                this.setFuelUISize(new Size(fuelSize.m_128451_("width"), fuelSize.m_128451_("height")));
                this.setFuelUICreator(recipe -> {
                    WidgetGroup recipeUI = new WidgetGroup();
                    recipeUI.setClientSideWidget();
                    IConfigurableWidget.deserializeNBT((IConfigurableWidget)recipeUI, (CompoundTag)fuelUITag, (Resource)texturesResource, (boolean)false);
                    this.bindXEIRecipeUI(recipeUI, recipe);
                    recipeUI.setSelfPosition(0, 0);
                    recipeUI.setBackground(new IGuiTexture[]{IGuiTexture.EMPTY});
                    return recipeUI;
                });
            }
        });
        return this;
    }

    public boolean isCreatedFromProjectFile() {
        return this.projectFile != null;
    }

    public void reloadFromProjectFile() {
        if (this.projectFile != null) {
            try {
                CompoundTag tag = NbtIo.m_128953_((File)this.projectFile);
                if (tag != null) {
                    ArrayDeque postTask = Queues.newArrayDeque();
                    this.loadProductiveTag(this.projectFile, tag, postTask);
                    postTask.forEach(Runnable::run);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.registryName.toString();
    }

    public ResourceLocation getFuelRegistryName() {
        return new ResourceLocation(this.registryName.m_135827_(), this.registryName.m_135815_() + ".fuel");
    }

    public List<MBDRecipe> searchFuelRecipe(RecipeManager recipeManager, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies() || !this.isRequireFuelForWorking()) {
            return Collections.emptyList();
        }
        ArrayList<MBDRecipe> matches = new ArrayList<MBDRecipe>();
        for (MBDRecipe recipe : recipeManager.m_44013_((RecipeType)this)) {
            if (!recipe.isFuel || !recipe.matchRecipe(holder).isSuccess() || !recipe.matchTickRecipe(holder).isSuccess()) continue;
            matches.add(recipe);
        }
        matches.sort(Comparator.comparingInt(r -> r.priority));
        return matches;
    }

    public List<MBDRecipe> searchRecipe(RecipeManager recipeManager, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies()) {
            return Collections.emptyList();
        }
        List<MBDRecipe> matches = recipeManager.m_44013_((RecipeType)this).parallelStream().filter(recipe -> !recipe.isFuel && recipe.matchRecipe(holder).isSuccess() && recipe.matchTickRecipe(holder).isSuccess()).collect(Collectors.toList());
        matches.sort(Comparator.comparingInt(r -> r.priority));
        return matches;
    }

    public MBDRecipeType prepareBuilder(Consumer<MBDRecipeBuilder> onPrepare) {
        onPrepare.accept(this.recipeBuilder);
        return this;
    }

    public MBDRecipeBuilder recipeBuilder(ResourceLocation id, Object ... append) {
        if (append.length > 0) {
            return this.recipeBuilder.copy(new ResourceLocation(id.m_135827_(), id.m_135815_() + Arrays.stream(append).map(Object::toString).map(FormattingUtil::toLowerCaseUnder).reduce("", (a, b) -> a + "_" + b)));
        }
        return this.recipeBuilder.copy(id);
    }

    public MBDRecipeBuilder recipeBuilder(String id, Object ... append) {
        return this.recipeBuilder(MBD2.id(id), append);
    }

    public MBDRecipeBuilder recipeBuilder(Supplier<? extends ItemLike> item, Object ... append) {
        return this.recipeBuilder(item.get(), append);
    }

    @HideFromJS
    public MBDRecipeBuilder recipeBuilder(ItemLike itemLike, Object ... append) {
        return this.recipeBuilder(new ResourceLocation(itemLike.m_5456_().m_5524_()), append);
    }

    public Object kjs$recipeBuilder() {
        if (LDLib.isKubejsLoaded()) {
            return new MBDRecipeSchema.MBDRecipeJS(this);
        }
        throw new UnsupportedOperationException("KubeJS is not loaded");
    }

    public MBDRecipeBuilder copyFrom(MBDRecipeBuilder builder) {
        return this.recipeBuilder.copyFrom(builder);
    }

    public MBDRecipeType onRecipeBuild(BiConsumer<MBDRecipeBuilder, Consumer<FinishedRecipe>> onBuild) {
        this.recipeBuilder.onSave(onBuild);
        return this;
    }

    @Nullable
    public MBDRecipe toMBDrecipe(RecipeType<?> recipeType, ResourceLocation id, Recipe<?> recipe) {
        MBDRecipe result = null;
        if (recipe instanceof MBDRecipe) {
            MBDRecipe mbdRecipe = (MBDRecipe)recipe;
            MBDRecipe copied = mbdRecipe.copy();
            copied.recipeType = this;
            result = copied;
        } else if (!recipe.m_7527_().isEmpty()) {
            ResourceLocation newID = new ResourceLocation(this.registryName.m_135827_(), this.registryName.m_135815_() + "/" + id.m_135815_());
            MBDRecipeBuilder builder = this.recipeBuilder(newID, new Object[0]).recipeType(this);
            for (Ingredient ingredient : recipe.m_7527_()) {
                builder.inputItems(ingredient);
            }
            builder.outputItems(recipe.m_8043_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_)));
            if (recipe instanceof SmeltingRecipe) {
                SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
                builder.duration(smeltingRecipe.m_43753_());
            }
            builder.isXEIHidden(!this.isProxyRecipeXEIVisible);
            result = builder.buildRawRecipe();
        }
        ResourceLocation proxyTypeId = ForgeRegistries.RECIPE_TYPES.getKey(recipeType);
        if (proxyTypeId != null) {
            TransferProxyRecipeEvent event = new TransferProxyRecipeEvent(this, proxyTypeId, recipeType, id, recipe, result);
            MinecraftForge.EVENT_BUS.post((Event)event.postCustomEvent());
            if (event.isCanceled()) {
                return null;
            }
            return event.mbdRecipe;
        }
        return result;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ArrayConfiguratorGroup proxyGroup = new ArrayConfiguratorGroup("recipe_type.proxy_recipes", true, () -> this.proxyRecipeTypes, (getter, setter) -> new SearchComponentConfigurator("editor.machine.recipe_type", getter, setter, (Object)RecipeType.f_44108_, true, (word, find) -> {
            for (RecipeType recipeType : ForgeRegistries.RECIPE_TYPES) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ResourceLocation id = ForgeRegistries.RECIPE_TYPES.getKey((Object)recipeType);
                if (id == null || !id.toString().contains(word.toLowerCase())) continue;
                find.accept(recipeType);
            }
        }, recipeType -> Optional.ofNullable(ForgeRegistries.RECIPE_TYPES.getKey(recipeType)).map(Object::toString).orElse("missing")), false);
        proxyGroup.setAddDefault(() -> RecipeType.f_44108_);
        proxyGroup.setOnAdd(this.proxyRecipeTypes::add);
        proxyGroup.setOnRemove(this.proxyRecipeTypes::remove);
        proxyGroup.setOnUpdate(list -> {
            this.proxyRecipeTypes.clear();
            this.proxyRecipeTypes.addAll((Collection<RecipeType<?>>)list);
        });
        proxyGroup.setTips(new String[]{"recipe_type.proxy_recipes.tooltip"});
        father.addConfigurators(new Configurator[]{proxyGroup});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        PersistedParser.serializeNBT((CompoundTag)tag, this.getClass(), (Object)this);
        ListTag proxyTag = new ListTag();
        for (RecipeType<?> type : this.proxyRecipeTypes) {
            ResourceLocation location = ForgeRegistries.RECIPE_TYPES.getKey(type);
            if (location == null) continue;
            proxyTag.add((Object)StringTag.m_129297_((String)location.toString()));
        }
        tag.m_128365_("proxyRecipeTypes", (Tag)proxyTag);
        CompoundTag recipesTag = new CompoundTag();
        for (Map.Entry<ResourceLocation, MBDRecipe> entry : this.builtinRecipes.entrySet()) {
            recipesTag.m_128365_(entry.getKey().toString(), (Tag)MBDRecipeSerializer.SERIALIZER.toNBT(entry.getValue()));
        }
        tag.m_128365_("builtinRecipes", (Tag)recipesTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        PersistedParser.deserializeNBT((CompoundTag)tag, new HashMap(), this.getClass(), (Object)this);
        this.proxyRecipeTypes.clear();
        ListTag proxyTag = tag.m_128437_("proxyRecipeTypes", 8);
        for (Tag type : proxyTag) {
            ResourceLocation location = new ResourceLocation(type.m_7916_());
            RecipeType recipeType = (RecipeType)ForgeRegistries.RECIPE_TYPES.getValue(location);
            if (recipeType == null) continue;
            this.proxyRecipeTypes.add(recipeType);
        }
        this.builtinRecipes.clear();
        CompoundTag recipesTag = tag.m_128469_("builtinRecipes");
        for (String key : recipesTag.m_128431_()) {
            MBDRecipe recipe = MBDRecipeSerializer.SERIALIZER.fromNBT(new ResourceLocation(key), recipesTag.m_128469_(key));
            recipe.recipeType = this;
            this.builtinRecipes.put(new ResourceLocation(key), recipe);
        }
    }

    public void bindXEIRecipeUI(WidgetGroup ui, MBDRecipe recipe) {
        WidgetUtils.widgetByIdForEach(ui, "^@progress_bar$", ProgressWidget.class, progress -> progress.setHoverTooltips(new Component[]{Component.m_237110_((String)"recipe.duration.value", (Object[])new Object[]{recipe.duration})}));
        WidgetUtils.widgetByIdForEach(ui, "^@duration$", LabelWidget.class, label -> label.setComponent((Component)Component.m_237110_((String)"recipe.duration.value", (Object[])new Object[]{recipe.duration})));
        WidgetUtils.widgetByIdForEach(ui, "^@condition$", TextBoxWidget.class, textBoxWidget -> textBoxWidget.setContent(recipe.conditions.stream().map(RecipeCondition::getTooltips).map(Component::getString).toList()));
        MBDRecipeType.bindCapIOUI(ui, recipe.inputs, IO.IN);
        MBDRecipeType.bindCapIOUI(ui, recipe.outputs, IO.OUT);
    }

    private static void bindCapIOUI(WidgetGroup ui, Map<RecipeCapability<?>, List<Content>> values, IO io) {
        values.forEach((cap, contents) -> {
            for (int i = 0; i < contents.size(); ++i) {
                Content content = (Content)contents.get(i);
                String id = content.uiName.isEmpty() ? "^@%s_%s_%d$".formatted(cap.name, io.name, i) : Pattern.quote(content.uiName);
                for (Widget widget : WidgetUtils.getWidgetsById(ui, id)) {
                    cap.bindXEIWidget(widget, content, switch (io) {
                        case IO.IN -> IngredientIO.INPUT;
                        case IO.OUT -> IngredientIO.OUTPUT;
                        case IO.BOTH -> IngredientIO.BOTH;
                        default -> IngredientIO.RENDER_ONLY;
                    });
                    ArrayList<Component> tooltips = new ArrayList<Component>();
                    content.appendTooltip(tooltips);
                    if (tooltips.isEmpty()) continue;
                    widget.appendHoverTooltips(tooltips);
                }
            }
        });
    }

    public WidgetGroup createRecipeUI(MBDRecipe recipe) {
        WidgetGroup ui = this.uiCreator.create(recipe);
        RecipeUIEvent event = new RecipeUIEvent(this, recipe, ui);
        MinecraftForge.EVENT_BUS.post((Event)event.postKubeJSEvent());
        return event.getRoot().setClientSideWidget();
    }

    public WidgetGroup createFuelUI(MBDRecipe recipe) {
        WidgetGroup ui = this.fuelUICreator.create(recipe);
        FuelRecipeUIEvent event = new FuelRecipeUIEvent(this, recipe, ui);
        MinecraftForge.EVENT_BUS.post((Event)event.postKubeJSEvent());
        return event.getRoot().setClientSideWidget();
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public MBDRecipeType setRecipeBuilder(MBDRecipeBuilder recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public MBDRecipeBuilder getRecipeBuilder() {
        return this.recipeBuilder;
    }

    public MBDRecipeType setIcon(IGuiTexture icon) {
        this.icon = icon;
        return this;
    }

    public IGuiTexture getIcon() {
        return this.icon;
    }

    public MBDRecipeType setFuelIcon(IGuiTexture fuelIcon) {
        this.fuelIcon = fuelIcon;
        return this;
    }

    public IGuiTexture getFuelIcon() {
        return this.fuelIcon;
    }

    public MBDRecipeType setRequireFuelForWorking(boolean requireFuelForWorking) {
        this.requireFuelForWorking = requireFuelForWorking;
        return this;
    }

    public boolean isRequireFuelForWorking() {
        return this.requireFuelForWorking;
    }

    public MBDRecipeType setXEIVisible(boolean isXEIVisible) {
        this.isXEIVisible = isXEIVisible;
        return this;
    }

    public boolean isXEIVisible() {
        return this.isXEIVisible;
    }

    public MBDRecipeType setProxyRecipeXEIVisible(boolean isProxyRecipeXEIVisible) {
        this.isProxyRecipeXEIVisible = isProxyRecipeXEIVisible;
        return this;
    }

    public boolean isProxyRecipeXEIVisible() {
        return this.isProxyRecipeXEIVisible;
    }

    public Map<ResourceLocation, MBDRecipe> getBuiltinRecipes() {
        return this.builtinRecipes;
    }

    public MBDRecipeType setUiCreator(UICreator uiCreator) {
        this.uiCreator = uiCreator;
        return this;
    }

    public UICreator getUiCreator() {
        return this.uiCreator;
    }

    public MBDRecipeType setUiSize(Size uiSize) {
        this.uiSize = uiSize;
        return this;
    }

    public Size getUiSize() {
        return this.uiSize;
    }

    public MBDRecipeType setFuelUICreator(UICreator fuelUICreator) {
        this.fuelUICreator = fuelUICreator;
        return this;
    }

    public UICreator getFuelUICreator() {
        return this.fuelUICreator;
    }

    public MBDRecipeType setFuelUISize(Size fuelUISize) {
        this.fuelUISize = fuelUISize;
        return this;
    }

    public Size getFuelUISize() {
        return this.fuelUISize;
    }

    public MBDRecipeType setProjectFile(@Nullable File projectFile) {
        this.projectFile = projectFile;
        return this;
    }

    @Nullable
    public File getProjectFile() {
        return this.projectFile;
    }

    @Deprecated
    public Map<RecipeType<?>, List<MBDRecipe>> getProxyRecipes() {
        return this.proxyRecipes;
    }

    public static interface UICreator {
        public static final UICreator DEFAULT = recipe -> new WidgetGroup();

        public WidgetGroup create(MBDRecipe var1);
    }
}

