/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern.predicates;

import com.google.common.base.Suppliers;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IAutoPersistedSerializable;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.api.block.ProxyPartBlock;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.pattern.MultiblockState;
import com.lowdragmc.mbd2.api.pattern.TraceabilityPredicate;
import com.lowdragmc.mbd2.api.pattern.error.PatternStringError;
import com.lowdragmc.mbd2.api.pattern.error.SinglePredicateError;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockPatternPanel;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleDirection;
import com.lowdragmc.mbd2.integration.ldlib.MBDLDLibPlugin;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SimplePredicate
implements IAutoPersistedSerializable,
IConfigurable {
    public static SimplePredicate ANY = new SimplePredicate(x -> true, null);
    public static SimplePredicate AIR = new SimplePredicate(blockWorldState -> blockWorldState.getWorld().m_46859_(blockWorldState.getPos()), null);
    @Nullable
    public Supplier<BlockInfo[]> candidates;
    public Predicate<MultiblockState> predicate;
    public Supplier<IGuiTexture> previewTexture = () -> IGuiTexture.EMPTY;
    @Configurable(name="config.block_pattern.predicate.minCount", tips={"config.block_pattern.predicate.minCount.tooltip.0", "config.block_pattern.predicate.minCount.tooltip.1"})
    @NumberRange(range={-1.0, 2.147483647E9})
    public int minCount = -1;
    @Configurable(name="config.block_pattern.predicate.maxCount", tips={"config.block_pattern.predicate.maxCount.tooltip.0", "config.block_pattern.predicate.maxCount.tooltip.1"})
    @NumberRange(range={-1.0, 2.147483647E9})
    public int maxCount = -1;
    @Configurable(name="config.block_pattern.predicate.minLayerCount", tips={"config.block_pattern.predicate.minLayerCount.tooltip.0", "config.block_pattern.predicate.minLayerCount.tooltip.1"})
    @NumberRange(range={-1.0, 2.147483647E9})
    public int minLayerCount = -1;
    @Configurable(name="config.block_pattern.predicate.maxLayerCount", tips={"config.block_pattern.predicate.maxLayerCount.tooltip.0", "config.block_pattern.predicate.maxLayerCount.tooltip.1"})
    @NumberRange(range={-1.0, 2.147483647E9})
    public int maxLayerCount = -1;
    @Configurable(name="config.block_pattern.predicate.previewCount", tips={"config.block_pattern.predicate.previewCount.tooltip.0", "config.block_pattern.predicate.previewCount.tooltip.1"})
    @NumberRange(range={-1.0, 2.147483647E9})
    public int previewCount = -1;
    @Configurable(name="config.block_pattern.predicate.disableRenderFormed", tips={"config.block_pattern.predicate.disableRenderFormed.tooltip"})
    public boolean disableRenderFormed = false;
    @Configurable(name="config.block_pattern.predicate.io", tips={"config.block_pattern.predicate.io.tooltip"})
    public IO io = IO.BOTH;
    @Configurable(name="config.block_pattern.predicate.slotName", tips={"config.block_pattern.predicate.slotName.tooltip"})
    public String slotName;
    @Configurable(name="config.block_pattern.predicate.nbt", tips={"config.block_pattern.predicate.nbt.tooltip"})
    public CompoundTag nbt = new CompoundTag();
    @Configurable(name="config.block_pattern.predicate.controller_nbt", tips={"config.block_pattern.predicate.controller_nbt.tooltip"})
    public CompoundTag controllerNbt = new CompoundTag();
    @Configurable(name="config.block_pattern.predicate.controllerFront", tips={"config.block_pattern.predicate.controllerFront.tooltip"}, subConfigurable=true)
    public ToggleDirection controllerFront = new ToggleDirection();
    @Configurable(name="config.block_pattern.predicate.tooltips", tips={"config.block_pattern.predicate.tooltips.tooltip"}, collapse=false)
    public final List<Component> toolTips = new ArrayList<Component>();
    @Configurable(name="config.block_pattern.predicate.allowOpenUI", tips={"config.block_pattern.predicate.allowOpenUI.tooltip.0", "config.block_pattern.predicate.allowOpenUI.tooltip.1"})
    public boolean allowOpenUI = true;

    protected SimplePredicate() {
        this(x -> true, null);
    }

    public SimplePredicate(Predicate<MultiblockState> predicate, @Nullable Supplier<BlockInfo[]> candidates) {
        this.predicate = predicate;
        this.candidates = candidates;
    }

    public String name() {
        if (this == AIR) {
            return "air";
        }
        if (this == ANY) {
            return "any";
        }
        return super.name();
    }

    public static CompoundTag serializeWrapper(SimplePredicate predicate) {
        return predicate.serializeNBT();
    }

    public static SimplePredicate deserializeWrapper(CompoundTag tag) {
        String type = tag.m_128461_("_type");
        if (type.equals("air")) {
            return AIR;
        }
        if (type.equals("any")) {
            return ANY;
        }
        AnnotationDetector.Wrapper<LDLRegister, ? extends SimplePredicate> wrapper = MBDLDLibPlugin.REGISTER_PREDICATES.get(type);
        if (wrapper != null) {
            SimplePredicate renderer = (SimplePredicate)wrapper.creator().get();
            renderer.deserializeNBT(tag);
            renderer.buildPredicate();
            return renderer;
        }
        return null;
    }

    public SimplePredicate buildPredicate() {
        this.previewTexture = Suppliers.memoize(() -> this.candidates == null ? new TextTexture(this.name()) : new ItemStackTexture((ItemStack[])Arrays.stream(this.candidates.get()).map(BlockInfo::getItemStackForm).toArray(ItemStack[]::new)));
        this.notifySceneUpdate();
        return this;
    }

    protected void notifySceneUpdate() {
        if (LDLib.isClient() && Editor.INSTANCE != null && Editor.INSTANCE.getCurrentProject() instanceof MultiblockMachineProject) {
            Editor.INSTANCE.getTabPages().tabs.values().stream().filter(MultiblockPatternPanel.class::isInstance).map(MultiblockPatternPanel.class::cast).findAny().ifPresent(MultiblockPatternPanel::onBlockPlaceholdersChanged);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getToolTips(TraceabilityPredicate predicates) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (this.toolTips != null && !this.toolTips.isEmpty()) {
            result.addAll(this.toolTips);
        }
        if (this.minCount == this.maxCount && this.maxCount != -1) {
            result.add((Component)Component.m_237110_((String)"mbd2.multiblock.pattern.error.limited_exact", (Object[])new Object[]{this.minCount}));
        } else if (this.minCount != this.maxCount && this.minCount != -1 && this.maxCount != -1) {
            result.add((Component)Component.m_237110_((String)"mbd2.multiblock.pattern.error.limited_within", (Object[])new Object[]{this.minCount, this.maxCount}));
        } else {
            if (this.minCount != -1) {
                result.add((Component)Component.m_237110_((String)"mbd2.multiblock.pattern.error.limited.1", (Object[])new Object[]{this.minCount}));
            }
            if (this.maxCount != -1) {
                result.add((Component)Component.m_237110_((String)"mbd2.multiblock.pattern.error.limited.0", (Object[])new Object[]{this.maxCount}));
            }
        }
        if (predicates == null) {
            return result;
        }
        if (predicates.isSingle()) {
            result.add((Component)Component.m_237115_((String)"mbd2.multiblock.pattern.single"));
        }
        if (predicates.hasAir()) {
            result.add((Component)Component.m_237115_((String)"mbd2.multiblock.pattern.replaceable_air"));
        }
        return result;
    }

    private boolean isProxyBlock(MultiblockState blockWorldState) {
        return blockWorldState.getBlockState().m_60734_() == ProxyPartBlock.BLOCK;
    }

    public boolean test(MultiblockState blockWorldState) {
        if (this.isProxyBlock(blockWorldState) || this.predicate.test(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    public boolean testLimited(MultiblockState blockWorldState) {
        if (this.isProxyBlock(blockWorldState) || this.testGlobal(blockWorldState) && this.testLayer(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    private boolean checkInnerConditions(MultiblockState blockWorldState) {
        Optional<Direction> front;
        IMultiController controller;
        CompoundTag merged;
        CompoundTag tag;
        BlockEntity te;
        if (this.io != IO.BOTH) {
            if (blockWorldState.io == IO.BOTH) {
                blockWorldState.io = this.io;
            } else if (blockWorldState.io != this.io) {
                blockWorldState.io = null;
            }
        }
        if (!(this.nbt.m_128456_() || blockWorldState.world.f_46443_ || (te = blockWorldState.getTileEntity()) == null || (tag = te.m_187480_()).equals((Object)(merged = tag.m_6426_().m_128391_(this.nbt))))) {
            blockWorldState.setError(new PatternStringError("The NBT fails to match"));
            return false;
        }
        if (!(this.controllerNbt.m_128456_() || blockWorldState.world.f_46443_ || (te = blockWorldState.getController().getHolder()) == null || (tag = te.m_187480_()).equals((Object)(merged = tag.m_6426_().m_128391_(this.controllerNbt))))) {
            blockWorldState.setError(new PatternStringError("The Controller NBT fails to match"));
            return true;
        }
        if (this.controllerFront.isEnable() && (controller = blockWorldState.getController()) != null && (front = controller.getFrontFacing()).isPresent() && front.get() != this.controllerFront.getValue()) {
            blockWorldState.setError(new PatternStringError("The Controller Front side fails to match"));
            return false;
        }
        if (this.slotName != null && !this.slotName.isEmpty()) {
            Map slots = (Map)blockWorldState.getMatchContext().getOrCreate("slots", Long2ObjectArrayMap::new);
            slots.computeIfAbsent(blockWorldState.getPos().m_121878_(), s -> new HashSet()).add(this.slotName);
            return true;
        }
        if (this.disableRenderFormed) {
            blockWorldState.getMatchContext().getOrCreate("renderMask", LongOpenHashSet::new).add(blockWorldState.getPos().m_121878_());
        }
        if (this.allowOpenUI) {
            blockWorldState.getMatchContext().getOrCreate("openUIMask", LongOpenHashSet::new).add(blockWorldState.getPos().m_121878_());
        }
        return true;
    }

    public boolean testGlobal(MultiblockState blockWorldState) {
        if (this.minCount == -1 && this.maxCount == -1) {
            return true;
        }
        Integer count = blockWorldState.getGlobalCount().get(this);
        boolean base = this.predicate.test(blockWorldState);
        count = (count == null ? 0 : count) + (base ? 1 : 0);
        blockWorldState.getGlobalCount().put(this, count);
        if (this.maxCount == -1 || count <= this.maxCount) {
            return base;
        }
        blockWorldState.setError(new SinglePredicateError(this, 0));
        return false;
    }

    public boolean testLayer(MultiblockState blockWorldState) {
        if (this.minLayerCount == -1 && this.maxLayerCount == -1) {
            return true;
        }
        Integer count = blockWorldState.getLayerCount().get(this);
        boolean base = this.predicate.test(blockWorldState);
        count = (count == null ? 0 : count) + (base ? 1 : 0);
        blockWorldState.getLayerCount().put(this, count);
        if (this.maxLayerCount == -1 || count <= this.maxLayerCount) {
            return base;
        }
        blockWorldState.setError(new SinglePredicateError(this, 2));
        return false;
    }

    public List<ItemStack> getCandidates() {
        if (LDLib.isClient()) {
            return this.candidates == null ? Collections.emptyList() : Arrays.stream(this.candidates.get()).filter(info -> info.getBlockState().m_60734_() != Blocks.f_50016_).map(blockInfo -> blockInfo.getItemStackForm((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_)).collect(Collectors.toList());
        }
        return this.candidates == null ? Collections.emptyList() : Arrays.stream(this.candidates.get()).filter(info -> info.getBlockState().m_60734_() != Blocks.f_50016_).map(BlockInfo::getItemStackForm).collect(Collectors.toList());
    }

    public IGuiTexture getPreviewTexture() {
        return this.previewTexture.get();
    }

    public String getTranslateKey() {
        return "config.%s.%s".formatted(this.group(), this.name());
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        father.addConfigurators(new Configurator[]{new WrapperConfigurator("config.block_pattern.predicate.preview", (Widget)new WidgetGroup(0, 0, 100, 100).addWidget((Widget)new ImageWidget(0, 0, 100, 100, IGuiTexture.EMPTY).setBorder(2, ColorPattern.T_WHITE.color)).addWidget((Widget)this.createPreview()))});
        super.buildConfigurator(father);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected SceneWidget createPreview() {
        final TrackedDummyWorld level = new TrackedDummyWorld();
        BlockInfo blockInfo = Optional.ofNullable(this.candidates).map(Supplier::get).filter(x -> ((BlockInfo[])x).length > 0).map(x -> x[0]).orElse(BlockInfo.EMPTY);
        level.addBlock(BlockPos.f_121853_, blockInfo);
        SceneWidget sceneWidget = new SceneWidget(0, 0, 100, 100, null){

            @OnlyIn(value=Dist.CLIENT)
            public void updateScreen() {
                super.updateScreen();
                if (this.gui.getTickCount() % 20L == 0L) {
                    BlockInfo blockInfo = Optional.ofNullable(SimplePredicate.this.candidates).map(Supplier::get).filter(x -> ((BlockInfo[])x).length > 0).map(x -> x[(int)(this.gui.getTickCount() / 20L % (long)((BlockInfo[])x).length)]).orElse(BlockInfo.EMPTY);
                    level.addBlock(BlockPos.f_121853_, blockInfo);
                }
            }
        };
        sceneWidget.setRenderFacing(false);
        sceneWidget.setRenderSelect(false);
        sceneWidget.setScalable(false);
        sceneWidget.setDraggable(false);
        sceneWidget.setIntractable(false);
        sceneWidget.createScene((Level)level);
        sceneWidget.getRenderer().setOnLookingAt(null);
        sceneWidget.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        return sceneWidget;
    }
}

