/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern.predicates;

import com.google.common.base.Suppliers;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;

@LDLRegister(name="blockstates", group="predicate")
public class PredicateStates
extends SimplePredicate {
    @Configurable(name="config.predicate.blockstates", tips={"config.predicate.blockstates.tooltip"}, collapse=false)
    protected BlockState[] states = new BlockState[]{Blocks.f_50156_.m_49966_()};

    public PredicateStates(BlockState ... states) {
        this.states = states;
        this.buildPredicate();
    }

    @ConfigSetter(field="states")
    public void setStates(BlockState[] states) {
        this.states = states;
        this.buildPredicate();
    }

    @Override
    public SimplePredicate buildPredicate() {
        this.states = (BlockState[])Arrays.stream(this.states).filter(Objects::nonNull).toArray(BlockState[]::new);
        if (this.states.length == 0) {
            this.states = new BlockState[]{Blocks.f_50375_.m_49966_()};
        }
        this.predicate = state -> ArrayUtils.contains((Object[])this.states, (Object)state.getBlockState());
        this.candidates = Suppliers.memoize(() -> (BlockInfo[])Arrays.stream(this.states).map(BlockInfo::fromBlockState).toArray(BlockInfo[]::new));
        return super.buildPredicate();
    }

    public PredicateStates() {
    }
}

