/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils.statistics.entry;

import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.utils.statistics.entry.StatisticEntry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class EntityStatisticEntry
extends StatisticEntry<Entity> {
    private int activeCount;

    @Override
    public void increment(Entity entity) {
        ServerLevel level;
        super.increment(entity);
        Level level2 = entity.m_9236_();
        if (level2 instanceof ServerLevel && this.isActive(entity, level = (ServerLevel)level2)) {
            ++this.activeCount;
        }
    }

    @Override
    public String formatValue() {
        if (Config.get().activationRange().enabled()) {
            int percentage = Math.round((float)this.activeCount / (float)this.count * 100.0f);
            return String.format("<c:#secondary>%d</c> <dark_gray>|</dark_gray> <gray>Active: %d%%</gray>", this.count, percentage);
        }
        return super.formatValue();
    }

    private boolean isActive(Entity entity, ServerLevel level) {
        return !entity.servercore$isInactive() && level.m_7726_().f_8325_.m_143145_().m_183913_(entity.m_146902_().m_45588_());
    }
}

