/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.services.platform.PlatformHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ServerCoreCommand {
    private static final String VALUE = "value";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder node = Commands.m_82127_((String)"servercore");
        node.then(ServerCoreCommand.reloadConfig());
        node.then(ServerCoreCommand.settings());
        if (Config.get().commands().statusCommandEnabled()) {
            node.then(Commands.m_82127_((String)"status").executes(ctx -> ServerCoreCommand.getStatus((CommandSourceStack)ctx.getSource())));
        }
        dispatcher.register(node);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"sc").redirect((CommandNode)node.build()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> reloadConfig() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(Permission.require("command.config", 2))).executes(ctx -> ServerCoreCommand.reload((CommandSourceStack)ctx.getSource()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> settings() {
        LiteralArgumentBuilder settings = (LiteralArgumentBuilder)Commands.m_82127_((String)"settings").requires(Permission.require("command.settings", 2));
        for (DynamicSetting setting : DynamicSetting.values()) {
            settings.then(Commands.m_82127_((String)setting.name().toLowerCase()).then(Commands.m_82129_((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)setting.getLowerBound(), (int)setting.getUpperBound())).executes(ctx -> ServerCoreCommand.modifyDynamic((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), setting))));
        }
        return settings;
    }

    private static int modifyDynamic(CommandSourceStack source, int value, DynamicSetting setting) {
        DynamicManager manager = DynamicManager.getInstance(source.m_81377_());
        setting.set(value, manager);
        source.m_288197_(() -> Formatter.parse("<c:#secondary>%s <c:#primary>has been set to <c:#secondary>%s".formatted(setting.getFormattedName(), setting.getFormattedValue())), false);
        return 1;
    }

    private static int reload(CommandSourceStack source) {
        boolean success = Config.reloadMainConfig();
        if (success) {
            source.m_288197_(() -> Component.m_237113_((String)"Config reloaded!").m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to reload config! Check the logs for more info.").m_130940_(ChatFormatting.RED));
        }
        return 1;
    }

    private static int getStatus(CommandSourceStack source) {
        CommandConfig config = Config.get().commands();
        source.m_288197_(() -> {
            MutableComponent component = Component.m_237119_();
            MutableComponent title = Component.m_237113_((String)"ServerCore").m_130938_(style -> style.m_178520_(config.tertiaryValue()));
            if (source.m_230897_()) {
                Formatter.addLines(component, 14, config.primaryValue(), (Component)title);
            } else {
                component.m_7220_((Component)title);
            }
            component.m_7220_(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Version: <c:#secondary>%s".formatted(PlatformHelper.getVersion())));
            for (DynamicSetting setting : DynamicSetting.values()) {
                component.m_7220_(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>%s: <c:#secondary>%s".formatted(setting.getFormattedName(), setting.getFormattedValue())));
            }
            return component;
        }, false);
        return 1;
    }
}

