/*
 * Decompiled with CFR 0.152.
 */
package youyihj.hotai.transformers;

import cpw.mods.modlauncher.api.ITransformer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.badiff.MemoryDiffs;
import org.badiff.imp.MemoryDiff;
import org.badiff.io.DefaultSerialization;
import org.objectweb.asm.tree.ClassNode;
import youyihj.hotai.HotaiTransformationService;
import youyihj.hotai.transformers.HotaiTransformer;

public class BytecodeTransformer
extends HotaiTransformer<byte[]>
implements ITransformer<ClassNode> {
    private final Path hotaiPath;

    public BytecodeTransformer(Path hotaiPath, Map<String, byte[]> transformations) {
        super(transformations);
        this.hotaiPath = hotaiPath;
    }

    @Override
    protected byte[] transform(byte[] src, byte[] transformation, String className) {
        this.replaceToDiff(src, transformation, className);
        return transformation;
    }

    private void replaceToDiff(byte[] src, byte[] transformation, String className) {
        MemoryDiff diff = MemoryDiffs.diff(src, transformation);
        Path diffPath = this.hotaiPath.resolve(className.replace("/", this.hotaiPath.getFileSystem().getSeparator()).concat(".badiff"));
        Path classPath = this.hotaiPath.resolve(className.replace("/", this.hotaiPath.getFileSystem().getSeparator()).concat(".class"));
        try {
            diff.serialize(DefaultSerialization.newInstance(), Files.newOutputStream(diffPath, new OpenOption[0]));
            Files.deleteIfExists(classPath);
        }
        catch (IOException e) {
            HotaiTransformationService.LOGGER.error("Failed to replace to diff for {}", (Object)className);
        }
    }
}

