/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.badiff.Op;
import org.badiff.io.RuntimeIOException;
import org.badiff.q.OpQueue;

public class StreamChunkingOpQueue
extends OpQueue {
    protected InputStream orig;
    protected InputStream target;
    protected int chunk;

    public StreamChunkingOpQueue(InputStream orig, InputStream target) {
        this(orig, target, 2048);
    }

    public StreamChunkingOpQueue(InputStream orig, InputStream target, int chunk) {
        this.orig = orig;
        this.target = target;
        this.chunk = chunk;
    }

    @Override
    protected boolean pull() {
        byte[] tbuf;
        byte[] obuf = this.orig != null ? this.readChunk(this.orig) : null;
        byte[] byArray = tbuf = this.target != null ? this.readChunk(this.target) : null;
        if (obuf != null) {
            this.prepare(new Op(1, obuf.length, obuf));
        } else {
            this.orig = null;
        }
        if (tbuf != null) {
            this.prepare(new Op(2, tbuf.length, tbuf));
        } else {
            this.target = null;
        }
        return obuf != null || tbuf != null;
    }

    protected byte[] readChunk(InputStream in) {
        try {
            byte[] buf = new byte[this.chunk];
            int r = in.read(buf);
            if (r == -1) {
                in.close();
                return null;
            }
            if (r == this.chunk) {
                return buf;
            }
            return Arrays.copyOf(buf, r);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }
}

