/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.badiff.Op;
import org.badiff.q.OpQueue;

public class PumpingOpQueue
extends OpQueue {
    protected ExecutorService worker;
    protected Runnable task;
    protected OpQueue source;
    protected BlockingQueue<Op> pipe;

    protected ThreadFactory workerFactory(OpQueue source) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, PumpingOpQueue.this.toString());
                t.setDaemon(true);
                return t;
            }
        };
    }

    public PumpingOpQueue(OpQueue source) {
        this(source, 1024);
    }

    public PumpingOpQueue(OpQueue source, int capacity) {
        this.source = source;
        this.worker = Executors.newSingleThreadExecutor(this.workerFactory(source));
        this.pipe = new ArrayBlockingQueue<Op>(capacity);
    }

    protected Runnable createTask() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Op e = PumpingOpQueue.this.source.poll();
                    while (e != null) {
                        PumpingOpQueue.this.pipe.put(e);
                        e = PumpingOpQueue.this.source.poll();
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    PumpingOpQueue.this.worker.shutdown();
                    while (true) {
                        try {
                            PumpingOpQueue.this.pipe.put(new Op(0, 1, null));
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }
        };
    }

    @Override
    protected boolean pull() {
        Op e;
        if (this.task == null) {
            this.task = this.createTask();
            this.worker.execute(this.task);
        }
        if ((e = (Op)this.pipe.poll()) != null) {
            if (e.getOp() == 0) {
                return false;
            }
            this.prepare(e);
            return true;
        }
        if (!this.worker.isShutdown()) {
            while (true) {
                try {
                    e = this.pipe.take();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            if (e.getOp() == 0) {
                return false;
            }
            this.prepare(e);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " <- " + this.source;
    }
}

