/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.util.ArrayList;
import java.util.List;
import org.badiff.Op;
import org.badiff.q.OpQueue;

public class FilterOpQueue
extends OpQueue {
    protected OpQueue source;
    protected List<Op> filtering = new ArrayList<Op>();

    public FilterOpQueue(OpQueue source) {
        this.source = source;
    }

    @Override
    public boolean offer(Op e) {
        return this.source.offer(e);
    }

    protected boolean require(int count) {
        while (this.filtering.size() < count) {
            Op e = this.source.poll();
            if (e == null) {
                return false;
            }
            this.filtering.add(e);
        }
        return true;
    }

    protected void drop(int count) {
        while (count-- > 0) {
            this.filtering.remove(0);
        }
    }

    protected boolean flush() {
        boolean flushed = false;
        while (this.filtering.size() > 0) {
            this.prepare(this.filtering.remove(0));
            flushed = true;
        }
        return flushed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " <- " + this.source;
    }
}

