/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.util.ArrayDeque;
import java.util.Deque;
import org.badiff.Op;
import org.badiff.q.OpQueue;

public class ChainOpQueue
extends OpQueue {
    protected Deque<OpQueue> chain = new ArrayDeque<OpQueue>();

    public ChainOpQueue(OpQueue ... links) {
        for (OpQueue q : links) {
            this.offer(q);
        }
    }

    public Deque<OpQueue> getChain() {
        return this.chain;
    }

    public boolean offer(OpQueue q) {
        return this.chain.offerLast(q);
    }

    @Override
    public boolean offer(Op e) {
        if (this.chain.size() == 0) {
            this.chain.offerLast(new OpQueue());
        }
        return this.chain.peekLast().offer(e);
    }

    @Override
    protected boolean pull() {
        while (this.chain.size() > 0) {
            Op e = this.chain.peekFirst().poll();
            if (e == null) {
                this.chain.pollFirst();
                continue;
            }
            this.prepare(e);
            return true;
        }
        return false;
    }
}

