/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.q;

import java.nio.ByteBuffer;
import org.badiff.Op;
import org.badiff.q.OpQueue;

public class BufferChunkingOpQueue
extends OpQueue {
    protected ByteBuffer orig;
    protected ByteBuffer target;
    protected int chunk;

    public BufferChunkingOpQueue(ByteBuffer orig, ByteBuffer target) {
        this(orig, target, 2048);
    }

    public BufferChunkingOpQueue(ByteBuffer orig, ByteBuffer target, int chunk) {
        this.orig = orig;
        this.target = target;
        this.chunk = chunk;
    }

    @Override
    protected boolean pull() {
        byte[] obuf = this.readChunk(this.orig);
        byte[] tbuf = this.readChunk(this.target);
        if (obuf != null) {
            this.prepare(new Op(1, obuf.length, obuf));
        }
        if (tbuf != null) {
            this.prepare(new Op(2, tbuf.length, tbuf));
        }
        return obuf != null || tbuf != null;
    }

    protected byte[] readChunk(ByteBuffer in) {
        if (in.remaining() == 0) {
            return null;
        }
        byte[] buf = new byte[Math.min(this.chunk, in.remaining())];
        in.get(buf);
        return buf;
    }
}

