/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;

public class PushbufferInputStream
extends InputStream {
    protected PushbackInputStream in;
    protected long pos;
    protected ByteBuffer buf;

    public PushbufferInputStream(InputStream in, int size) {
        this.in = new PushbackInputStream(in, size);
        this.buf = ByteBuffer.allocate(size);
    }

    public long position() {
        return this.pos;
    }

    public void position(long pos) throws IOException {
        this.skip(pos - this.pos);
    }

    public long first() {
        return this.pos - (long)this.buf.position();
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        for (skipped = 0L; n > skipped; ++skipped) {
            this.read();
        }
        if (n < 0L) {
            this.buf.position(this.buf.position() + (int)n);
            byte[] b = new byte[(int)(-n)];
            this.buf.get(b);
            this.buf.position(this.buf.position() + (int)n);
            this.in.unread(b);
            skipped = n;
        }
        this.pos += skipped;
        return skipped;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r >= 0) {
            if (this.buf.remaining() == 0) {
                this.buf.get();
                this.buf.compact();
            }
            this.buf.put((byte)r);
            ++this.pos;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r >= 0) {
            if (this.buf.remaining() < r) {
                this.buf.position(this.buf.limit() - r);
                this.buf.compact();
            }
            this.buf.put(b, 0, r);
            this.pos += (long)r;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r >= 0) {
            if (this.buf.remaining() < r) {
                this.buf.position(this.buf.limit() - r);
                this.buf.compact();
            }
            this.buf.put(b, off, r);
            this.pos += (long)r;
        }
        return r;
    }
}

