/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.badiff.Op;
import org.badiff.imp.FileDiff;
import org.badiff.imp.MemoryDiff;
import org.badiff.io.GraphContext;
import org.badiff.io.Serialization;
import org.badiff.util.Streams;

public class DefaultSerialization
implements Serialization {
    private List<Serializer<?>> serializers = new ArrayList();
    private int depth;
    private Map<Object, Object> context = new HashMap<Object, Object>();
    private GraphContext graphContext = new GraphContext(this.context);

    public static DefaultSerialization newInstance() {
        return new DefaultSerialization();
    }

    public DefaultSerialization() {
        this.serializers.add(new Serializer<Class>(Class.class){

            @Override
            public void write(DataOutput out, Class obj) throws IOException {
                for (int i = 0; i < DefaultSerialization.this.serializers.size(); ++i) {
                    if (((Serializer)DefaultSerialization.this.serializers.get(i)).type() != obj) continue;
                    DefaultSerialization.this.writeLong(out, i);
                    return;
                }
                throw new NotSerializableException(obj.getName());
            }

            @Override
            public Class read(DataInput in) throws IOException {
                return ((Serializer)DefaultSerialization.this.serializers.get((int)DefaultSerialization.this.readLong(in))).type();
            }
        });
        this.serializers.add(new Serializer<Byte>(Byte.class){

            @Override
            public void write(DataOutput out, Byte obj) throws IOException {
                out.writeByte(obj.byteValue());
            }

            @Override
            public Byte read(DataInput in) throws IOException {
                return in.readByte();
            }
        });
        this.serializers.add(new Serializer<Integer>(Integer.class){

            @Override
            public void write(DataOutput out, Integer obj) throws IOException {
                DefaultSerialization.this.writeLong(out, obj.intValue());
            }

            @Override
            public Integer read(DataInput in) throws IOException {
                return (int)DefaultSerialization.this.readLong(in);
            }
        });
        this.serializers.add(new Serializer<Long>(Long.class){

            @Override
            public void write(DataOutput out, Long obj) throws IOException {
                DefaultSerialization.this.writeLong(out, obj);
            }

            @Override
            public Long read(DataInput in) throws IOException {
                return DefaultSerialization.this.readLong(in);
            }
        });
        this.serializers.add(new Serializer<String>(String.class){

            @Override
            public void write(DataOutput out, String obj) throws IOException {
                out.writeUTF(obj);
            }

            @Override
            public String read(DataInput in) throws IOException {
                return in.readUTF();
            }
        });
        this.serializers.add(new Serializer<byte[]>(byte[].class){

            @Override
            public void write(DataOutput out, byte[] obj) throws IOException {
                DefaultSerialization.this.writeLong(out, obj != null ? (long)(obj.length + 1) : 0L);
                if (obj != null) {
                    out.write(obj);
                }
            }

            @Override
            public byte[] read(DataInput in) throws IOException {
                int size = (int)DefaultSerialization.this.readLong(in) - 1;
                if (size == -1) {
                    return null;
                }
                byte[] obj = new byte[size];
                in.readFully(obj);
                return obj;
            }
        });
        this.serializers.add(new Serializer<Op>(Op.class){

            @Override
            public void write(DataOutput out, Op obj) throws IOException {
                obj.serialize(DefaultSerialization.this, Streams.asStream(out));
            }

            @Override
            public Op read(DataInput in) throws IOException {
                Op op = new Op();
                op.deserialize(DefaultSerialization.this, Streams.asStream(in));
                return op;
            }
        });
        this.serializers.add(new Serializer<MemoryDiff>(MemoryDiff.class){

            @Override
            public void write(DataOutput out, MemoryDiff obj) throws IOException {
                obj.serialize(DefaultSerialization.this, Streams.asStream(out));
            }

            @Override
            public MemoryDiff read(DataInput in) throws IOException {
                MemoryDiff md = new MemoryDiff();
                md.deserialize(DefaultSerialization.this, Streams.asStream(in));
                return md;
            }
        });
        this.serializers.add(new Serializer<FileDiff>(FileDiff.class){

            @Override
            public void write(DataOutput out, FileDiff obj) throws IOException {
                obj.serialize(DefaultSerialization.this, Streams.asStream(out));
            }

            @Override
            public FileDiff read(DataInput in) throws IOException {
                FileDiff md = new FileDiff(File.createTempFile("FileDiff", ".tmp"));
                md.deserialize(DefaultSerialization.this, Streams.asStream(in));
                return md;
            }
        });
    }

    protected void addSerializer(Serializer<?> s) {
        this.serializers.add(s);
    }

    public void writeLong(DataOutput out, long val) throws IOException {
        int v = (int)(val & 0x7FL);
        if (val >>> 7 != 0L) {
            v |= 0x80;
        }
        out.writeByte(v);
        if (val >>> 7 != 0L) {
            this.writeLong(out, val >>> 7);
        }
    }

    public long readLong(DataInput in) throws IOException {
        return this.readLong(in, 0L, 0);
    }

    private long readLong(DataInput in, long accum, int shift) throws IOException {
        long b = 0xFF & in.readByte();
        accum |= (b & 0x7FL) << shift;
        if ((b & 0x80L) == 0L) {
            return accum;
        }
        return this.readLong(in, accum, shift + 7);
    }

    @Override
    public <T> void writeObject(OutputStream out, Class<T> type, T object) throws IOException {
        if (this.depth == 0) {
            this.graphContext.clear();
        }
        ++this.depth;
        try {
            for (Serializer<?> s : this.serializers) {
                if (s.type() != type) continue;
                s.write(new DataOutputStream(out), object);
                return;
            }
            throw new NotSerializableException(type.getName());
        }
        finally {
            --this.depth;
        }
    }

    @Override
    public <T> T readObject(InputStream in, Class<T> type) throws IOException {
        if (this.depth == 0) {
            this.graphContext.clear();
        }
        ++this.depth;
        try {
            for (Serializer<?> s : this.serializers) {
                if (s.type() != type) continue;
                T t = type.cast(s.read(new DataInputStream(in)));
                return t;
            }
            throw new NotSerializableException(type.getName());
        }
        finally {
            --this.depth;
        }
    }

    @Override
    public Map<Object, Object> context() {
        return this.context;
    }

    @Override
    public GraphContext graphContext() {
        return this.graphContext;
    }

    protected static abstract class Serializer<T> {
        protected Class<T> type;

        public Serializer(Class<T> type) {
            this.type = type;
        }

        public Class<T> type() {
            return this.type;
        }

        public abstract void write(DataOutput var1, T var2) throws IOException;

        public abstract T read(DataInput var1) throws IOException;
    }
}

