/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.imp;

import java.io.IOException;
import java.io.InputStream;
import org.badiff.Op;
import org.badiff.Queueable;
import org.badiff.io.DefaultSerialization;
import org.badiff.io.RuntimeIOException;
import org.badiff.io.Serialization;
import org.badiff.q.OpQueue;

public class StreamQueueable
implements Queueable {
    protected Serialization serial;
    protected InputStream in;

    public StreamQueueable(InputStream in) {
        this(in, DefaultSerialization.newInstance());
    }

    public StreamQueueable(InputStream in, Serialization serial) {
        this.in = in;
        this.serial = serial;
    }

    @Override
    public OpQueue queue() throws IOException {
        return new StreamOpQueue();
    }

    private class StreamOpQueue
    extends OpQueue {
        private boolean closed;

        private StreamOpQueue() {
        }

        @Override
        public boolean offer(Op e) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean pull() {
            if (this.closed) {
                return false;
            }
            try {
                Op e = StreamQueueable.this.serial.readObject(StreamQueueable.this.in, Op.class);
                if (e.getOp() == 0) {
                    this.closed = true;
                    return false;
                }
                this.prepare(e);
                return true;
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
        }
    }
}

