/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.alg;

import java.util.Arrays;
import org.badiff.alg.EditGraph;

public class MinNextEditGraph
extends EditGraph {
    protected int minNext = 1;

    public MinNextEditGraph(int size) {
        this(size, 1);
    }

    public MinNextEditGraph(int size, int minNext) {
        super(size);
        this.minNext = minNext;
    }

    @Override
    public void compute(byte[] orig, byte[] target) {
        int pos;
        int x;
        int y;
        this.xval = new byte[orig.length + 1];
        this.yval = new byte[target.length + 1];
        System.arraycopy(orig, 0, this.xval, 1, orig.length);
        System.arraycopy(target, 0, this.yval, 1, target.length);
        Arrays.fill(this.flags, (byte)-1);
        for (y = 0; y < this.yval.length; ++y) {
            for (x = 0; x < this.xval.length; ++x) {
                if (x == 0 || y == 0 || this.xval[x] != this.yval[y] || this.flags[pos = x + y * this.xval.length] == 3 || this.flags[pos] == 0) continue;
                int extent = 0;
                int ix = x;
                int iy = y;
                do {
                    ++extent;
                } while (++ix != this.xval.length && ++iy != this.yval.length && this.xval[ix] == this.yval[iy]);
                while (--ix >= x && --iy >= y) {
                    this.flags[ix + iy * this.xval.length] = extent >= this.minNext ? 3 : 0;
                }
            }
        }
        for (y = 0; y < this.yval.length; ++y) {
            for (x = 0; x < this.xval.length; ++x) {
                int ilen;
                if (x == 0 && y == 0) continue;
                pos = x + y * this.xval.length;
                if (x > 0 && y > 0 && this.flags[pos] == 3) {
                    this.lengths[pos] = (short)(1 + this.lengths[pos - this.xval.length - 1]);
                    continue;
                }
                int dlen = x > 0 ? (int)(1 + this.lengths[pos - 1]) : Short.MAX_VALUE;
                int n = ilen = y > 0 ? (int)(1 + this.lengths[pos - this.xval.length]) : Short.MAX_VALUE;
                if (dlen <= ilen) {
                    this.flags[pos] = 1;
                    this.lengths[pos] = dlen;
                    continue;
                }
                this.flags[pos] = 2;
                this.lengths[pos] = ilen;
            }
        }
    }

    public int getMinNext() {
        return this.minNext;
    }

    public void setMinNext(int minNext) {
        if (minNext < 1) {
            throw new IllegalArgumentException();
        }
        this.minNext = minNext;
    }
}

