/*
 * Decompiled with CFR 0.152.
 */
package org.badiff.alg;

import java.util.ArrayList;
import org.badiff.Op;
import org.badiff.alg.Graph;
import org.badiff.q.CompactingOpQueue;
import org.badiff.q.ListOpQueue;
import org.badiff.q.OpQueue;

public class AdjustableInertialGraph
implements Graph {
    private static final int[][] DEFAULT_TRANSITION_COSTS = new int[][]{{1, 1, 1, 1}, {3, 1, 3, 4}, {2, 2, 1, 3}, {1, 2, 3, 1}};
    protected static final int DELETE = 0;
    protected static final int INSERT = 1;
    protected static final int NEXT = 2;
    protected static final int NUM_FIELDS = 3;
    protected float[] cost;
    protected final int capacity;
    protected byte[] xval;
    protected byte[] yval;
    protected float stop_stop = DEFAULT_TRANSITION_COSTS[0][0];
    protected float stop_delete = DEFAULT_TRANSITION_COSTS[0][1];
    protected float stop_insert = DEFAULT_TRANSITION_COSTS[0][2];
    protected float stop_next = DEFAULT_TRANSITION_COSTS[0][3];
    protected float delete_stop = DEFAULT_TRANSITION_COSTS[1][0];
    protected float delete_delete = DEFAULT_TRANSITION_COSTS[1][1];
    protected float delete_insert = DEFAULT_TRANSITION_COSTS[1][2];
    protected float delete_next = DEFAULT_TRANSITION_COSTS[1][3];
    protected float insert_stop = DEFAULT_TRANSITION_COSTS[2][0];
    protected float insert_delete = DEFAULT_TRANSITION_COSTS[2][1];
    protected float insert_insert = DEFAULT_TRANSITION_COSTS[2][2];
    protected float insert_next = DEFAULT_TRANSITION_COSTS[2][3];
    protected float next_stop = DEFAULT_TRANSITION_COSTS[3][0];
    protected float next_delete = DEFAULT_TRANSITION_COSTS[3][1];
    protected float next_insert = DEFAULT_TRANSITION_COSTS[3][2];
    protected float next_next = DEFAULT_TRANSITION_COSTS[3][3];

    public AdjustableInertialGraph(int capacity) {
        if (capacity < 4) {
            throw new IllegalArgumentException("capacity must be >= 4");
        }
        this.capacity = capacity;
        this.cost = new float[3 * capacity];
    }

    public float getCost(byte from, byte to) {
        switch (from) {
            case 0: {
                switch (to) {
                    case 0: {
                        return this.stop_stop;
                    }
                    case 1: {
                        return this.stop_delete;
                    }
                    case 2: {
                        return this.stop_insert;
                    }
                    case 3: {
                        return this.stop_next;
                    }
                }
            }
            case 1: {
                switch (to) {
                    case 0: {
                        return this.delete_stop;
                    }
                    case 1: {
                        return this.delete_delete;
                    }
                    case 2: {
                        return this.delete_insert;
                    }
                    case 3: {
                        return this.delete_next;
                    }
                }
            }
            case 2: {
                switch (to) {
                    case 0: {
                        return this.insert_stop;
                    }
                    case 1: {
                        return this.insert_delete;
                    }
                    case 2: {
                        return this.insert_insert;
                    }
                    case 3: {
                        return this.insert_next;
                    }
                }
            }
            case 3: {
                switch (to) {
                    case 0: {
                        return this.next_stop;
                    }
                    case 1: {
                        return this.next_delete;
                    }
                    case 2: {
                        return this.next_insert;
                    }
                    case 3: {
                        return this.next_next;
                    }
                }
            }
        }
        throw new IllegalArgumentException("from:" + from + " to:" + to);
    }

    public void setCost(byte from, byte to, float cost) {
        switch (from) {
            case 0: {
                switch (to) {
                    case 0: {
                        this.stop_stop = cost;
                        return;
                    }
                    case 1: {
                        this.stop_delete = cost;
                        return;
                    }
                    case 2: {
                        this.stop_insert = cost;
                        return;
                    }
                    case 3: {
                        this.stop_next = cost;
                        return;
                    }
                }
            }
            case 1: {
                switch (to) {
                    case 0: {
                        this.delete_stop = cost;
                        return;
                    }
                    case 1: {
                        this.delete_delete = cost;
                        return;
                    }
                    case 2: {
                        this.delete_insert = cost;
                        return;
                    }
                    case 3: {
                        this.delete_next = cost;
                        return;
                    }
                }
            }
            case 2: {
                switch (to) {
                    case 0: {
                        this.insert_stop = cost;
                        return;
                    }
                    case 1: {
                        this.insert_delete = cost;
                        return;
                    }
                    case 2: {
                        this.insert_insert = cost;
                        return;
                    }
                    case 3: {
                        this.insert_next = cost;
                        return;
                    }
                }
            }
            case 3: {
                switch (to) {
                    case 0: {
                        this.next_stop = cost;
                        return;
                    }
                    case 1: {
                        this.next_delete = cost;
                        return;
                    }
                    case 2: {
                        this.next_insert = cost;
                        return;
                    }
                    case 3: {
                        this.next_next = cost;
                        return;
                    }
                }
            }
        }
        throw new IllegalArgumentException("from:" + from + " to:" + to);
    }

    @Override
    public void compute(byte[] orig, byte[] target) {
        if ((orig.length + 1) * (target.length + 1) > this.capacity) {
            throw new IllegalArgumentException("diff axes exceed graph capacity");
        }
        this.xval = new byte[orig.length + 1];
        System.arraycopy(orig, 0, this.xval, 1, orig.length);
        this.yval = new byte[target.length + 1];
        System.arraycopy(target, 0, this.yval, 1, target.length);
        this.cost[0] = 0.0f;
        this.cost[1] = 0.0f;
        this.cost[2] = 0.0f;
        for (int y = 0; y < this.yval.length; ++y) {
            for (int x = 0; x < this.xval.length; ++x) {
                float enc;
                float eic;
                float edc;
                if (x == 0 && y == 0) continue;
                int pos = y * this.xval.length + x;
                if (x == 0) {
                    edc = 32767.0f;
                    eic = this.cost[(pos - this.xval.length) * 3 + 1];
                    enc = 32767.0f;
                } else if (y == 0) {
                    edc = this.cost[(pos - 1) * 3 + 0];
                    eic = 32767.0f;
                    enc = 32767.0f;
                } else {
                    edc = this.cost[(pos - 1) * 3 + 0];
                    eic = this.cost[(pos - this.xval.length) * 3 + 1];
                    enc = this.xval[x] == this.yval[y] ? this.cost[(pos - 1 - this.xval.length) * 3 + 2] : 32767.0f;
                }
                float cost = edc + this.delete_delete;
                cost = Math.min(cost, eic + this.insert_delete);
                cost = Math.min(cost, enc + this.next_delete);
                this.cost[pos * 3 + 0] = Math.min(cost, 32767.0f);
                cost = eic + this.insert_insert;
                cost = Math.min(cost, edc + this.delete_insert);
                cost = Math.min(cost, enc + this.next_insert);
                this.cost[pos * 3 + 1] = Math.min(cost, 32767.0f);
                cost = enc + this.next_next;
                cost = Math.min(cost, edc + this.delete_next);
                cost = Math.min(cost, eic + this.insert_next);
                this.cost[pos * 3 + 2] = Math.min(cost, 32767.0f);
            }
        }
    }

    @Override
    public OpQueue queue() {
        GraphOpQueue rq = new GraphOpQueue();
        ArrayList<Op> ops = new ArrayList<Op>();
        Op e = rq.poll();
        while (e != null) {
            ops.add(0, e);
            e = rq.poll();
        }
        OpQueue q = new ListOpQueue(ops);
        q = new CompactingOpQueue(q);
        return q;
    }

    protected class GraphOpQueue
    extends OpQueue {
        protected int pos;
        protected byte prev = 0;
        protected int x;
        protected int y;

        public GraphOpQueue() {
            this.pos = AdjustableInertialGraph.this.xval.length * AdjustableInertialGraph.this.yval.length - 1;
            this.x = AdjustableInertialGraph.this.xval.length - 1;
            this.y = AdjustableInertialGraph.this.yval.length - 1;
        }

        @Override
        protected boolean pull() {
            if (this.pos == 0) {
                return false;
            }
            int op = -1;
            float cost = Float.MAX_VALUE;
            if (this.x > 0 && this.y > 0 && AdjustableInertialGraph.this.xval[this.x] == AdjustableInertialGraph.this.yval[this.y]) {
                op = 3;
                cost = AdjustableInertialGraph.this.cost[(this.pos - 1 - AdjustableInertialGraph.this.xval.length) * 3 + 2] + AdjustableInertialGraph.this.getCost((byte)3, this.prev);
            }
            if (this.y > 0 && AdjustableInertialGraph.this.cost[(this.pos - AdjustableInertialGraph.this.xval.length) * 3 + 1] + AdjustableInertialGraph.this.getCost((byte)2, this.prev) < cost) {
                op = 2;
                cost = AdjustableInertialGraph.this.cost[(this.pos - AdjustableInertialGraph.this.xval.length) * 3 + 1] + AdjustableInertialGraph.this.getCost((byte)2, this.prev);
            }
            if (this.x > 0 && AdjustableInertialGraph.this.cost[(this.pos - 1) * 3 + 0] + AdjustableInertialGraph.this.getCost((byte)1, this.prev) < cost) {
                op = 1;
                cost = AdjustableInertialGraph.this.cost[(this.pos - 1) * 3 + 0] + AdjustableInertialGraph.this.getCost((byte)1, this.prev);
            }
            Op e = null;
            switch (op) {
                case 3: {
                    e = new Op(3, 1, null);
                    this.pos = this.pos - 1 - AdjustableInertialGraph.this.xval.length;
                    --this.x;
                    --this.y;
                    break;
                }
                case 2: {
                    e = new Op(2, 1, new byte[]{AdjustableInertialGraph.this.yval[this.pos / AdjustableInertialGraph.this.xval.length]});
                    this.pos -= AdjustableInertialGraph.this.xval.length;
                    --this.y;
                    break;
                }
                case 1: {
                    e = new Op(1, 1, new byte[]{AdjustableInertialGraph.this.xval[this.pos % AdjustableInertialGraph.this.xval.length]});
                    --this.pos;
                    --this.x;
                }
            }
            if (e == null) {
                throw new IllegalStateException();
            }
            this.prepare(e);
            this.prev = e.getOp();
            return true;
        }
    }
}

