/*
 * Decompiled with CFR 0.152.
 */
package org.badiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.badiff.Diff;
import org.badiff.imp.FileDiff;
import org.badiff.io.RandomInputStream;
import org.badiff.q.OneWayOpQueue;
import org.badiff.q.StreamChunkingOpQueue;
import org.badiff.q.UndoOpQueue;
import org.badiff.util.Diffs;

public class FileDiffs {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileDiff diff(File orig, File target) throws IOException {
        FileDiff fd = new FileDiff(File.createTempFile(orig.getName(), ".diff"));
        FileInputStream oin = new FileInputStream(orig);
        try {
            FileInputStream tin = new FileInputStream(target);
            try {
                fd.store(Diffs.improved(Diffs.queue(oin, tin)));
            }
            finally {
                ((InputStream)tin).close();
            }
        }
        finally {
            ((InputStream)oin).close();
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileDiff mdiff(File orig, File target) throws IOException {
        FileDiff fd = new FileDiff(File.createTempFile(orig.getName(), ".diff"));
        RandomInputStream oin = new RandomInputStream(orig);
        try {
            RandomInputStream tin = new RandomInputStream(target);
            try {
                fd.store(Diffs.improved(new StreamChunkingOpQueue(oin, tin)));
            }
            finally {
                tin.close();
            }
        }
        finally {
            oin.close();
        }
        return fd;
    }

    public static File apply(File orig, Diff diff) throws IOException {
        File target = File.createTempFile(orig.getName(), ".target");
        Diffs.apply(diff, orig, target);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileDiff udiff(File orig, File target) throws IOException {
        FileDiff fd = new FileDiff(File.createTempFile(orig.getName(), ".udiff"));
        FileInputStream oin = new FileInputStream(orig);
        try {
            FileInputStream tin = new FileInputStream(target);
            try {
                fd.store(new OneWayOpQueue(Diffs.improved(Diffs.queue(oin, tin))));
            }
            finally {
                ((InputStream)tin).close();
            }
        }
        finally {
            ((InputStream)oin).close();
        }
        return fd;
    }

    public static File undo(File target, Diff diff) throws IOException {
        File orig = File.createTempFile(target.getName(), ".orig");
        Diffs.apply(new UndoOpQueue(diff.queue()), target, orig);
        return orig;
    }

    public static FileDiff udiff(Diff diff) throws IOException {
        FileDiff ud = new FileDiff(File.createTempFile("udiff", ".udiff"));
        ud.store(new OneWayOpQueue(diff.queue()));
        return ud;
    }

    public static FileDiff undo(Diff diff) throws IOException {
        FileDiff ud = new FileDiff(File.createTempFile("undo", ".undo"));
        ud.store(new UndoOpQueue(diff.queue()));
        return ud;
    }

    private FileDiffs() {
    }
}

