/*
 * Decompiled with CFR 0.152.
 */
package org.badiff;

import java.io.File;
import org.badiff.imp.BadiffFileDiff;
import org.badiff.util.Digests;

public class BadiffCli {
    public static void main(String[] args) {
        try {
            BadiffCli._main(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void _main(String[] args) throws Exception {
        File target;
        File orig;
        BadiffFileDiff diff;
        if (args.length == 0) {
            BadiffCli.help();
            return;
        }
        if ("diff".equals(args[0])) {
            if (args.length != 4) {
                BadiffCli.help();
                return;
            }
            diff = new BadiffFileDiff(args[1]);
            orig = new File(args[2]);
            target = new File(args[3]);
            diff.diff(orig, target);
        }
        if ("patch".equals(args[0])) {
            if (args.length != 4) {
                BadiffCli.help();
                return;
            }
            diff = new BadiffFileDiff(args[1]);
            orig = new File(args[2]);
            target = new File(args[3]);
            diff.apply(orig, target);
        }
        if ("info".equals(args[0])) {
            if (args.length != 2) {
                BadiffCli.help();
                return;
            }
            diff = new BadiffFileDiff(args[1]);
            BadiffFileDiff.Header header = diff.header();
            BadiffFileDiff.Header.Stats stats = header.getStats();
            BadiffFileDiff.Header.Optional opt = header.getOptional();
            BadiffCli.field("Input Size", stats.getInputSize());
            BadiffCli.field("Output Size", stats.getOutputSize());
            BadiffCli.field("Patch Size", diff.length());
            BadiffCli.field("Inserts", stats.getInsertCount());
            BadiffCli.field("Deletes", stats.getDeleteCount());
            BadiffCli.field("Copies", stats.getNextCount());
            BadiffCli.field("Rewinds", stats.getRewindCount());
            if (opt != null) {
                if (opt.getHashAlgorithm() != null) {
                    BadiffCli.field("Hash", opt.getHashAlgorithm());
                }
                if (opt.getPreHash() != null) {
                    BadiffCli.field("Input Hash", Digests.pretty(opt.getPreHash()));
                }
                if (opt.getPostHash() != null) {
                    BadiffCli.field("Output Hash", Digests.pretty(opt.getPostHash()));
                }
            }
        }
    }

    private static void field(String header, Object data) {
        header = header + "....................";
        header = header.substring(0, 20);
        System.out.println(header + data);
    }

    private static void help() {
        System.out.println("Command and options required:");
        System.out.println();
        System.out.println("diff DIFF_FILE ORIG_FILE TARGET_FILE");
        System.out.println("\tCompute the difference between ORIG_FILE and TARGET_FILE and store in DIFF_FILE");
        System.out.println();
        System.out.println("patch DIFF_FILE ORIG_FILE TARGET_FILE");
        System.out.println("\tApply a difference from DIFF_FILE to ORIG_FILE to generate TARGET_FILE");
        System.out.println();
        System.out.println("info DIFF_FILE");
        System.out.println("\tDisplay statistics and optional data from DIFF_FILE");
    }
}

