/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.DeferredInventoryDetection;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FTBQuestsInventoryListener
implements ContainerListener {
    public final ServerPlayer player;
    private static final Map<Item, List<ItemStack>> inventorySummaryCache = new HashMap<Item, List<ItemStack>>();
    private static final List<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>();

    public FTBQuestsInventoryListener(ServerPlayer p) {
        this.player = p;
    }

    public static void detect(ServerPlayer player, ItemStack craftedItem, long sourceTask) {
        List<Task> tasksToCheck;
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || PlayerHooks.isFake((Player)player)) {
            return;
        }
        List<Task> list = tasksToCheck = craftedItem.m_41619_() ? file.getSubmitTasks() : file.getCraftingTasks();
        if (!tasksToCheck.isEmpty()) {
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                TeamData data = file.getNullableTeamData(team.getId());
                if (data != null && !data.isLocked()) {
                    file.withPlayerContext(player, () -> {
                        FTBQuestsInventoryListener.buildInventorySummary(player);
                        for (Task task : tasksToCheck) {
                            if (task.id == sourceTask || !data.canStartTasks(task.getQuest())) continue;
                            task.submitTask(data, player, craftedItem);
                        }
                        inventorySummaryCache.clear();
                        nonEmptyStacks.clear();
                    });
                }
            });
        }
    }

    private static void buildInventorySummary(ServerPlayer player) {
        player.m_150109_().f_35974_.forEach(stack -> {
            if (!stack.m_41619_()) {
                inventorySummaryCache.computeIfAbsent(stack.m_41720_(), k -> new ArrayList()).add(stack);
                nonEmptyStacks.add((ItemStack)stack);
            }
        });
    }

    public static Collection<ItemStack> getStacksForPlayerOfType(Item item) {
        return inventorySummaryCache.getOrDefault(item, List.of());
    }

    public static Collection<ItemStack> getAllNonEmptyStacksForPlayer() {
        return nonEmptyStacks;
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    public void m_7934_(AbstractContainerMenu menu, int index, ItemStack stack) {
        int slotNum;
        if (!stack.m_41619_() && menu.m_38853_((int)index).f_40218_ == this.player.m_150109_() && (slotNum = menu.m_38853_(index).m_150661_()) >= 0 && slotNum < this.player.m_150109_().f_35974_.size()) {
            int delay = Mth.m_14045_((int)ServerQuestFile.INSTANCE.getDetectionDelay(), (int)0, (int)200);
            if (delay == 0) {
                FTBQuestsInventoryListener.detect(this.player, ItemStack.f_41583_, 0L);
            } else {
                DeferredInventoryDetection.scheduleInventoryCheck(this.player, delay);
            }
        }
    }
}

