/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.traderefresh.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class TRConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        TRConfig.register(ModConfig.Type.CLIENT, CLIENT_SPEC);
        TRConfig.register(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    private static void register(ModConfig.Type type, IConfigSpec<?> spec) {
        ModContainer mod = ModLoadingContext.get().getActiveContainer();
        String path = "l2_configs/" + mod.getModId() + "-" + type.extension() + ".toml";
        ModLoadingContext.get().registerConfig(type, spec, path);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showEnchProperties;

        Client(ForgeConfigSpec.Builder builder) {
            this.showEnchProperties = builder.comment("Show enchantment properties like tradeable and enchantable").comment("Will not work when Apotheosis is installed").define("showEnchProperties", true);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue alwaysAllowRefresh;
        public final ForgeConfigSpec.BooleanValue allowEmeraldBlockForceRestock;
        public final ForgeConfigSpec.BooleanValue banAllTradeEnchantmentsByDefault;
        public final ForgeConfigSpec.ConfigValue<List<String>> tradeNamespaceBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> tradeNamespaceWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<String>> tradeIdBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> tradeIdWhitelist;
        public final ForgeConfigSpec.BooleanValue banAllTableEnchantmentsByDefault;
        public final ForgeConfigSpec.ConfigValue<List<String>> tableNamespaceBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> tableNamespaceWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<String>> tableIdBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> tableIdWhitelist;

        Common(ForgeConfigSpec.Builder builder) {
            this.alwaysAllowRefresh = builder.comment("Always allow refreshing trade.").comment(" Only trades added at current villager level will be refreshed.").define("alwaysAllowRefresh", false);
            this.allowEmeraldBlockForceRestock = builder.comment("Allow player to use emerald block to force restock").define("allowEmeraldBlockForceRestock", true);
            this.banAllTradeEnchantmentsByDefault = builder.define("banAllTradeEnchantmentsByDefault", false);
            this.tradeNamespaceBlacklist = builder.define("tradeNamespaceBlacklist", new ArrayList(List.of()));
            this.tradeNamespaceWhitelist = builder.define("tradeNamespaceWhitelist", new ArrayList<String>(List.of("minecraft")));
            this.tradeIdBlacklist = builder.define("tradeIdBlacklist", new ArrayList(List.of()));
            this.tradeIdWhitelist = builder.define("tradeIdWhitelist", new ArrayList<String>(List.of("minecraft:unbreaking")));
            this.banAllTableEnchantmentsByDefault = builder.define("banAllTableEnchantmentsByDefault", false);
            this.tableNamespaceBlacklist = builder.define("tableNamespaceBlacklist", new ArrayList(List.of()));
            this.tableNamespaceWhitelist = builder.define("tableNamespaceWhitelist", new ArrayList<String>(List.of("minecraft")));
            this.tableIdBlacklist = builder.define("tableIdBlacklist", new ArrayList(List.of()));
            this.tableIdWhitelist = builder.define("tableIdWhitelist", new ArrayList<String>(List.of("minecraft:unbreaking")));
        }
    }
}

