/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.shadowizardlib.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ItemAttributeModifierEvent;

public class ShadowEvents {
    public static Vec3 getEntityCenter(Entity entity) {
        return entity.m_20191_().m_82399_();
    }

    public static List<Entity> getEntitiesAround(Entity center, double x, double y, double z) {
        List targets = center.m_9236_().m_45933_(center, center.m_20191_().m_82377_(x, y, z));
        return targets;
    }

    public static void findAndRemoveVanillaModifier(ItemAttributeModifierEvent event, Attribute attribute, UUID baseUUID) {
        event.getOriginalModifiers().get((Object)attribute).stream().filter(modifier -> modifier.m_22209_() == baseUUID).findAny().ifPresent(modifier -> event.removeModifier(attribute, modifier));
    }

    public static List<Entity> getEntitiesAround(Entity caster, Level pLevel, double size, @Nullable BiPredicate<Entity, Entity> filter) {
        List targets = pLevel.m_45976_(Entity.class, caster.m_20191_().m_82400_(size));
        if (filter != null) {
            ArrayList filteredTargets = Lists.newArrayList();
            for (Entity entity : targets) {
                if (!filter.test(caster, entity)) continue;
                filteredTargets.add(entity);
            }
            targets = filteredTargets;
        }
        return targets;
    }

    public static Entity getNearestEntity(Entity caster, Level pLevel, double size, @Nullable BiPredicate<Entity, Entity> filter) {
        List<Entity> targets = ShadowEvents.getEntitiesAround(caster, pLevel, size, filter);
        Entity target = null;
        double lowestSoFar = Double.MAX_VALUE;
        for (Entity closestSoFar : targets) {
            double testDistance = caster.m_20270_(closestSoFar);
            if (!(testDistance < lowestSoFar)) continue;
            target = closestSoFar;
        }
        return target;
    }

    public static Entity getPointedEntity(Level level, Entity caster, float range, float error, boolean stopsAtSolid, @Nullable BiPredicate<Entity, Entity> filter) {
        Vec3 direction = ShadowEvents.calculateViewVector(caster.m_146909_(), caster.m_146908_()).m_82541_();
        direction = direction.m_82542_((double)range, (double)range, (double)range);
        Vec3 center = caster.m_146892_().m_82549_(direction);
        Entity returnEntity = caster;
        double playerX = caster.m_146892_().f_82479_;
        double playerY = caster.m_146892_().f_82480_;
        double playerZ = caster.m_146892_().f_82481_;
        double listedEntityX = center.m_7096_();
        double listedEntityY = center.m_7098_();
        double listedEntityZ = center.m_7094_();
        int particleInterval = (int)Math.round(caster.m_20238_(center));
        for (int k = 1; k < 1 + particleInterval; ++k) {
            double lineX = playerX * (1.0 - (double)k / (double)particleInterval) + listedEntityX * ((double)k / (double)particleInterval);
            double lineY = playerY * (1.0 - (double)k / (double)particleInterval) + listedEntityY * ((double)k / (double)particleInterval);
            double lineZ = playerZ * (1.0 - (double)k / (double)particleInterval) + listedEntityZ * ((double)k / (double)particleInterval);
            Vec3 start = new Vec3(lineX + (double)error, lineY + (double)error, lineZ + (double)error);
            Vec3 end = new Vec3(lineX - (double)error, lineY - (double)error, lineZ - (double)error);
            AABB area = new AABB(start, end);
            List targets = level.m_45933_(caster, area);
            Entity target = null;
            double lowestSoFar = Double.MAX_VALUE;
            for (Entity closestSoFar : targets) {
                double testDistance;
                if (filter != null && !filter.test(caster, closestSoFar) || !((testDistance = closestSoFar.m_20238_(center)) < lowestSoFar)) continue;
                target = closestSoFar;
            }
            if (target != null) {
                returnEntity = target;
                break;
            }
            if (stopsAtSolid && caster.m_9236_().m_8055_(new BlockPos(Mth.m_14107_((double)lineX), Mth.m_14107_((double)lineY), Mth.m_14107_((double)lineZ))).m_280296_()) break;
        }
        return returnEntity;
    }

    public static Vec3 calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        double f2 = Math.cos(f1);
        double f3 = Math.sin(f1);
        double f4 = Math.cos(f);
        double f5 = Math.sin(f);
        return new Vec3(f3 * f4, -f5, f2 * f4);
    }

    public static double blockHeight(Level level, Entity caster, float range, float error, int maxHeight, boolean stopsAtSolid) {
        BlockPos startPos = ShadowEvents.getPointedEntity(level, caster, range, error, stopsAtSolid, null).m_20183_();
        double returnHeight = startPos.m_123342_();
        for (int i = startPos.m_123342_() + 1; i < startPos.m_123342_() + maxHeight; ++i) {
            BlockPos testBlockPost = new BlockPos(startPos.m_123341_(), i, startPos.m_123343_());
            if (!level.m_8055_(testBlockPost).m_280296_() && i != startPos.m_123342_() + maxHeight - 1) continue;
            returnHeight = i;
            break;
        }
        return returnHeight;
    }

    public static Vec3 getPoint(Level level, Entity caster, float range, float error, boolean centerBlock, boolean stopsAtEntity, boolean stopsAtSolid, boolean stopsAtLiquid) {
        Vec3 center;
        Vec3 direction = ShadowEvents.calculateViewVector(caster.m_146909_(), caster.m_146908_()).m_82541_();
        direction = direction.m_82542_((double)range, (double)range, (double)range);
        Vec3 returnPoint = center = caster.m_146892_().m_82549_(direction);
        double playerX = caster.m_146892_().f_82479_;
        double playerY = caster.m_146892_().f_82480_;
        double playerZ = caster.m_146892_().f_82481_;
        double listedEntityX = center.m_7096_();
        double listedEntityY = center.m_7098_();
        double listedEntityZ = center.m_7094_();
        int particleInterval = (int)Math.round(caster.m_20238_(center));
        for (int k = 1; k < 1 + particleInterval; ++k) {
            BlockPos pos;
            double lineX = playerX * (1.0 - (double)k / (double)particleInterval) + listedEntityX * ((double)k / (double)particleInterval);
            double lineY = playerY * (1.0 - (double)k / (double)particleInterval) + listedEntityY * ((double)k / (double)particleInterval);
            double lineZ = playerZ * (1.0 - (double)k / (double)particleInterval) + listedEntityZ * ((double)k / (double)particleInterval);
            Vec3 start = new Vec3(lineX + (double)error, lineY + (double)error, lineZ + (double)error);
            Vec3 end = new Vec3(lineX - (double)error, lineY - (double)error, lineZ - (double)error);
            AABB area = new AABB(start, end);
            List targets = level.m_45933_(caster, area);
            Entity target = null;
            double lowestSoFar = Double.MAX_VALUE;
            for (Entity closestSoFar : targets) {
                double testDistance;
                if (!(closestSoFar instanceof LivingEntity) || !((testDistance = closestSoFar.m_20238_(center)) < lowestSoFar)) continue;
                target = closestSoFar;
            }
            if (stopsAtEntity && target != null) {
                if (!centerBlock) break;
                pos = target.m_20183_();
                returnPoint = pos.m_252807_();
                break;
            }
            if (stopsAtLiquid && level.m_8055_(new BlockPos(Mth.m_14107_((double)lineX), Mth.m_14107_((double)lineY), Mth.m_14107_((double)lineZ))).m_60734_() instanceof LiquidBlock) {
                if (!centerBlock) break;
                pos = new BlockPos(Mth.m_14107_((double)returnPoint.f_82479_), Mth.m_14107_((double)returnPoint.f_82480_), Mth.m_14107_((double)returnPoint.f_82481_));
                returnPoint = pos.m_252807_();
                break;
            }
            if (stopsAtSolid && level.m_8055_(new BlockPos(Mth.m_14107_((double)lineX), Mth.m_14107_((double)lineY), Mth.m_14107_((double)lineZ))).m_280296_()) {
                if (!centerBlock) break;
                pos = new BlockPos(Mth.m_14107_((double)returnPoint.f_82479_), Mth.m_14107_((double)returnPoint.f_82480_), Mth.m_14107_((double)returnPoint.f_82481_));
                returnPoint = pos.m_252807_();
                break;
            }
            returnPoint = new Vec3(lineX, lineY, lineZ);
        }
        return returnPoint;
    }

    public static BlockPos getBlockPoint(Entity caster, float range) {
        Vec3 direction = ShadowEvents.calculateViewVector(caster.m_146909_(), caster.m_146908_()).m_82541_();
        direction = direction.m_82542_((double)range, (double)range, (double)range);
        Vec3 center = caster.m_146892_().m_82549_(direction);
        double playerX = caster.m_146892_().f_82479_;
        double playerY = caster.m_146892_().f_82480_;
        double playerZ = caster.m_146892_().f_82481_;
        double listedEntityX = center.m_7096_();
        double listedEntityY = center.m_7098_();
        double listedEntityZ = center.m_7094_();
        int particleInterval = (int)Math.round(caster.m_20238_(center));
        BlockPos blockPos = new BlockPos(Mth.m_14107_((double)center.f_82479_), Mth.m_14107_((double)center.f_82480_), Mth.m_14107_((double)center.f_82481_));
        for (int k = 1; k < 1 + particleInterval; ++k) {
            double lineX = playerX * (1.0 - (double)k / (double)particleInterval) + listedEntityX * ((double)k / (double)particleInterval);
            double lineY = playerY * (1.0 - (double)k / (double)particleInterval) + listedEntityY * ((double)k / (double)particleInterval);
            double lineZ = playerZ * (1.0 - (double)k / (double)particleInterval) + listedEntityZ * ((double)k / (double)particleInterval);
            BlockPos tempPos = new BlockPos(Mth.m_14107_((double)lineX), Mth.m_14107_((double)lineY), Mth.m_14107_((double)lineZ));
            if (!caster.m_9236_().m_8055_(tempPos).m_280296_()) continue;
            blockPos = tempPos;
            break;
        }
        return blockPos;
    }

    public static void summonParticleLine(SimpleParticleType type, Entity caster, Vec3 casterPos, Vec3 targetPos, int count, double xOff, double yOff, double zOff, double speed) {
        double playerX = casterPos.f_82479_;
        double playerY = casterPos.f_82480_;
        double playerZ = casterPos.f_82481_;
        double listedEntityX = targetPos.f_82479_;
        double listedEntityY = targetPos.f_82480_;
        double listedEntityZ = targetPos.f_82481_;
        int particleInterval = (int)Math.round(caster.m_20238_(targetPos));
        ServerLevel level = (ServerLevel)caster.m_9236_();
        for (int k = 1; k < 1 + particleInterval; ++k) {
            double lineX = playerX * (1.0 - (double)k / (double)particleInterval) + listedEntityX * ((double)k / (double)particleInterval);
            double lineY = playerY * (1.0 - (double)k / (double)particleInterval) + listedEntityY * ((double)k / (double)particleInterval);
            double lineZ = playerZ * (1.0 - (double)k / (double)particleInterval) + listedEntityZ * ((double)k / (double)particleInterval);
            level.m_8767_((ParticleOptions)type, lineX, lineY, lineZ, count, xOff, yOff, zOff, speed);
        }
    }

    @Nullable
    public static Entity getEntityByUUID(Level level, @Nullable UUID uuid) {
        if (uuid == null || !(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (Entity entity : serverLevel.m_8583_()) {
            if (entity == null || !entity.m_20148_().equals(uuid)) continue;
            return entity;
        }
        return null;
    }
}

