/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block;

import alabaster.crabbersdelight.common.block.entity.CrabTrapBlockEntity;
import alabaster.crabbersdelight.common.registry.ModBlockEntity;
import alabaster.crabbersdelight.common.utils.TextUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CrabTrapBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public CrabTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof CrabTrapBlockEntity) {
                CrabTrapBlockEntity crabTrapBlockEntity = (CrabTrapBlockEntity)blockentity;
                Containers.m_19010_((Level)level, (BlockPos)pos, crabTrapBlockEntity.getInventory().getItems());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity tileEntity;
        if (!level.f_46443_ && (tileEntity = level.m_7702_(pos)) instanceof CrabTrapBlockEntity) {
            CrabTrapBlockEntity crabTrapBlockEntity = (CrabTrapBlockEntity)tileEntity;
            if (state.m_61143_((Property)WATERLOGGED) == Boolean.TRUE || state.m_61143_((Property)HANGING) == Boolean.TRUE) {
                if (CrabTrapBlockEntity.isSurroundedByWater(level, pos) == Boolean.TRUE) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)crabTrapBlockEntity, (BlockPos)pos);
                } else {
                    player.m_5661_((Component)TextUtil.getTranslation("block.crab_trap.insufficient_surrounding_water", new Object[0]), true);
                }
            } else {
                player.m_5661_((Component)TextUtil.getTranslation("block.crab_trap.not_waterlogged", new Object[0]), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0);
        }
        return Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateAbove = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean hangingFlag = !stateAbove.m_60795_() && !stateAbove.m_60713_(Blocks.f_49990_) && !stateAbove.m_60713_(Blocks.f_49991_);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hangingFlag));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState stateAbove = level.m_8055_(currentPos.m_7494_());
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!(stateAbove.m_60795_() || stateAbove.m_60713_(Blocks.f_49990_) || stateAbove.m_60713_(Blocks.f_49991_))) {
            return (BlockState)state.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)super.m_7417_(state, dir, neighborState, level, currentPos, neighborPos).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrabTrapBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.f_46443_ ? null : CrabTrapBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)ModBlockEntity.CRAB_TRAP.get()), CrabTrapBlockEntity::serverTick);
    }
}

