/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.moestweaks.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.MobSpawnEvent;

public class MonsterWearsArmor {
    public static void onMobFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof Zombie || mob instanceof Skeleton || mob instanceof AbstractIllager) {
            BlockPos levelSpawnPos = mob.m_9236_().m_220360_();
            double distanceToSpawn = Math.sqrt(levelSpawnPos.m_123331_((Vec3i)mob.m_20183_()));
            if (distanceToSpawn < 1000.0) {
                return;
            }
            RandomSource random = event.getLevel().m_213780_();
            double armorProbability = Math.min(1.0, distanceToSpawn / 100.0 / 100.0);
            if (random.m_188500_() < armorProbability) {
                double quality = Math.min(1.0, distanceToSpawn / 12000.0);
                MonsterWearsArmor.equipArmor(mob, quality, random);
            }
        }
    }

    private static void equipArmor(Mob mob, double quality, RandomSource random) {
        if (mob.m_6844_(EquipmentSlot.HEAD).m_41619_() && random.m_188500_() < 2.0 * quality) {
            mob.m_8061_(EquipmentSlot.HEAD, MonsterWearsArmor.getHelmetByQuality(quality, random));
        }
        quality *= quality;
        if (mob.m_6844_(EquipmentSlot.FEET).m_41619_() && random.m_188500_() < 2.0 * quality) {
            mob.m_8061_(EquipmentSlot.FEET, MonsterWearsArmor.getBootsByQuality(quality, random));
        }
        quality *= quality;
        if (mob.m_6844_(EquipmentSlot.LEGS).m_41619_() && random.m_188500_() < 2.0 * quality) {
            mob.m_8061_(EquipmentSlot.LEGS, MonsterWearsArmor.getLeggingsByQuality(quality, random));
        }
        quality *= 0.8;
        if (mob.m_6844_(EquipmentSlot.CHEST).m_41619_() && random.m_188500_() < 2.0 * quality) {
            mob.m_8061_(EquipmentSlot.CHEST, MonsterWearsArmor.getChestplateByQuality(quality, random));
        }
    }

    private static ItemStack getHelmetByQuality(double quality, RandomSource random) {
        if (quality > 0.66) {
            return new ItemStack((ItemLike)Items.f_42468_);
        }
        if (quality > 0.33) {
            return new ItemStack((ItemLike)Items.f_42464_);
        }
        return new ItemStack((ItemLike)Items.f_42407_);
    }

    private static ItemStack getChestplateByQuality(double quality, RandomSource random) {
        if (quality > 0.66) {
            return new ItemStack((ItemLike)Items.f_42469_);
        }
        if (quality > 0.33) {
            return new ItemStack((ItemLike)Items.f_42465_);
        }
        return new ItemStack((ItemLike)Items.f_42408_);
    }

    private static ItemStack getLeggingsByQuality(double quality, RandomSource random) {
        if (quality > 0.66) {
            return new ItemStack((ItemLike)Items.f_42470_);
        }
        if (quality > 0.33) {
            return new ItemStack((ItemLike)Items.f_42466_);
        }
        return new ItemStack((ItemLike)Items.f_42462_);
    }

    private static ItemStack getBootsByQuality(double quality, RandomSource random) {
        if (quality > 0.66) {
            return new ItemStack((ItemLike)Items.f_42471_);
        }
        if (quality > 0.33) {
            return new ItemStack((ItemLike)Items.f_42467_);
        }
        return new ItemStack((ItemLike)Items.f_42463_);
    }
}

