/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.moestweaks;

import com.moepus.moestweaks.Config;
import com.moepus.moestweaks.ConfigParser;
import com.moepus.moestweaks.effects.EffectRegistry;
import com.moepus.moestweaks.events.AdrenalineEffectGiver;
import com.moepus.moestweaks.events.DamagedMonsterArmor;
import com.moepus.moestweaks.events.HideShield;
import com.moepus.moestweaks.events.MonsterWearsArmor;
import com.moepus.moestweaks.events.NoCustomSpawner;
import com.moepus.moestweaks.events.NoFireSpread;
import com.moepus.moestweaks.events.NoNetherPortal;
import com.moepus.moestweaks.events.SilverFishNoExp;
import com.moepus.moestweaks.events.VillageSpawnPoint;
import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="moestweaks")
public class MoesTweaks {
    public static final String MODID = "moestweaks";
    public static final Logger LOGGER = LogUtils.getLogger();
    Config config = ConfigParser.getConfig();

    public MoesTweaks() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(NoCustomSpawner::onLevelLoaded);
        if (this.config.stopFire) {
            forgeEventBus.addListener(NoFireSpread::onLevelLoaded);
        }
        if (this.config.villageSpawnPoint) {
            forgeEventBus.addListener(VillageSpawnPoint::onCreateSpawnPosition);
        }
        if (this.config.stopNetherPortal) {
            forgeEventBus.addListener(NoNetherPortal::onPortalSpawn);
        }
        if (this.config.bakaSilverFish) {
            forgeEventBus.addListener(SilverFishNoExp::onExpDrop);
        }
        if (this.config.adrenalineEffect) {
            EffectRegistry.MOB_EFFECTS.register(modEventBus);
            forgeEventBus.addListener(EventPriority.LOWEST, AdrenalineEffectGiver::onLivingHurt);
        }
        if (this.config.damagedMonsterArmor) {
            forgeEventBus.addListener(EventPriority.LOWEST, DamagedMonsterArmor::onMobFinalizeSpawn);
        }
        if (this.config.monsterWearsArmor) {
            forgeEventBus.addListener(MonsterWearsArmor::onMobFinalizeSpawn);
        }
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        if (FMLEnvironment.dist.equals((Object)Dist.CLIENT) && this.config.hideShield) {
            forgeEventBus.addListener(HideShield::onHandRender);
        }
    }
}

