/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.grinder;

import com.lance5057.butchercraft.ButchercraftBlockEntities;
import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.tags.ButchercraftItemTags;
import com.lance5057.butchercraft.workstations.BlockEntityItemHandler;
import com.lance5057.butchercraft.workstations.grinder.GrinderBlock;
import com.lance5057.butchercraft.workstations.grinder.GrinderContainer;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GrinderBlockEntity
extends BlockEntity {
    private final LazyOptional<IItemHandlerModifiable> handler = LazyOptional.of(this::createHandler);
    private ItemStack output = ItemStack.f_41583_;
    private int itemsUsed = 0;
    private int grinds = 0;
    private int grindsMax = 0;
    private boolean isExtruder = false;

    public GrinderBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ButchercraftBlockEntities.GRINDER.get(), pPos, pState);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new BlockEntityItemHandler<GrinderBlockEntity>(this, 3){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 1) {
                    return stack.m_204117_(ButchercraftItemTags.GRINDER_ATTACHMENT);
                }
                if (slot == 2) {
                    return stack.m_204117_(ButchercraftItemTags.SAUSAGE_CASING) && this.getStackInSlot(1).m_150930_((Item)ButchercraftItems.EXTRUDER_TIP.get());
                }
                return true;
            }

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return 8;
                }
                return 1;
            }

            protected void onContentsChanged(int slot) {
                GrinderBlockEntity.this.updateInventory();
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (this.getStackInSlot(slot) == ItemStack.f_41583_) {
                    if (slot == 0) {
                        Optional r = GrinderBlockEntity.this.f_58857_.m_7465_().m_44015_((RecipeType)ButchercraftRecipes.GRINDER.get(), (Container)new GrinderContainer(stack, this.getStackInSlot(1)), GrinderBlockEntity.this.f_58857_);
                        if (r.isPresent()) {
                            ((GrinderBlockEntity)((Object)this.getBlockEntity())).setupRecipe(((GrinderRecipe)r.get()).getGrinds(), ((GrinderRecipe)r.get()).m_8043_(null), this.getStackInSlot(1), ((GrinderRecipe)r.get()).count);
                            ((GrinderBlockEntity)((Object)this.getBlockEntity())).updateInventory();
                            return super.insertItem(slot, stack, simulate);
                        }
                    } else {
                        ((GrinderBlockEntity)((Object)this.getBlockEntity())).updateInventory();
                        return super.insertItem(slot, stack, simulate);
                    }
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ((GrinderBlockEntity)((Object)this.getBlockEntity())).zeroProgress();
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public void extractItem(Player playerEntity, IItemHandlerModifiable inventory) {
        if (!inventory.getStackInSlot(0).m_41619_()) {
            ItemStack itemStack = inventory.getStackInSlot(0).m_41777_();
            playerEntity.m_36356_(itemStack);
            inventory.setStackInSlot(0, ItemStack.f_41583_);
            this.zeroProgress();
            this.updateInventory();
            return;
        }
        if (!inventory.getStackInSlot(2).m_41619_()) {
            ItemStack itemStack = inventory.getStackInSlot(2).m_41777_();
            playerEntity.m_36356_(itemStack);
            inventory.setStackInSlot(2, ItemStack.f_41583_);
            this.zeroProgress();
            this.updateInventory();
            return;
        }
        if (!inventory.getStackInSlot(1).m_41619_() && inventory.getStackInSlot(0).m_41619_()) {
            ItemStack itemStack = inventory.getStackInSlot(1).m_41777_();
            playerEntity.m_36356_(itemStack);
            inventory.setStackInSlot(1, ItemStack.f_41583_);
            this.zeroProgress();
            this.updateInventory();
            return;
        }
        this.updateInventory();
    }

    public ItemStack insertItem(IItemHandler inventory, ItemStack heldItem) {
        for (int i = 0; i < 3; ++i) {
            if (!inventory.isItemValid(i, heldItem) || inventory.insertItem(i, heldItem, true).equals(heldItem, false)) continue;
            heldItem = inventory.insertItem(i, heldItem.m_41777_(), false);
            this.updateInventory();
            return heldItem;
        }
        this.updateInventory();
        return heldItem;
    }

    public void extractItem(Player playerEntity) {
        this.handler.ifPresent(inventory -> this.extractItem(playerEntity, (IItemHandlerModifiable)inventory));
    }

    public ItemStack insertItem(ItemStack heldItem) {
        Optional s;
        if (this.handler.isPresent() && (s = this.handler.map(i -> this.insertItem((IItemHandler)i, heldItem))).isPresent()) {
            return (ItemStack)s.get();
        }
        return heldItem;
    }

    public void zeroProgress() {
        this.itemsUsed = 0;
        this.grinds = 0;
        this.grindsMax = 0;
        this.output = ItemStack.f_41583_;
        this.isExtruder = false;
    }

    public void setupRecipe(int grindsMax, ItemStack output, ItemStack extruder, int used) {
        this.zeroProgress();
        this.grindsMax = grindsMax;
        this.output = output;
        this.itemsUsed = used;
        if (extruder.m_150930_((Item)ButchercraftItems.EXTRUDER_TIP.get())) {
            this.isExtruder = true;
        }
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public ItemStack getInsertedItem() {
        return this.handler.map(inventory -> inventory.getStackInSlot(0)).orElse(ItemStack.f_41583_);
    }

    public ItemStack getAttachment() {
        return this.handler.map(inventory -> inventory.getStackInSlot(1)).orElse(ItemStack.f_41583_);
    }

    public ItemStack getCasing() {
        return this.handler.map(inventory -> inventory.getStackInSlot(2)).orElse(ItemStack.f_41583_);
    }

    public int getGrind() {
        return this.grinds;
    }

    public int getMaxGrind() {
        return this.grindsMax;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt = this.writeNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNBT(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        tag = this.writeNBT(tag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.readNBT(tag);
    }

    void readNBT(CompoundTag nbt) {
        IItemHandler itemInteractionHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(this::createHandler);
        ((ItemStackHandler)itemInteractionHandler).deserializeNBT(nbt.m_128469_("inventory"));
        this.grinds = nbt.m_128451_("grinds");
        this.grindsMax = nbt.m_128451_("grinds_max");
        this.output = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("output"));
    }

    CompoundTag writeNBT(CompoundTag tag) {
        IItemHandler itemInteractionHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(this::createHandler);
        tag.m_128365_("inventory", (Tag)((ItemStackHandler)itemInteractionHandler).serializeNBT());
        tag.m_128405_("grinds", this.grinds);
        tag.m_128405_("grinds_max", this.grindsMax);
        tag.m_128365_("output", (Tag)this.output.serializeNBT());
        return tag;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readNBT(nbt);
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt = this.writeNBT(nbt);
    }

    public Optional<GrinderRecipe> matchRecipe(ItemStack ingredient, ItemStack attachment) {
        if (this.f_58857_ != null) {
            return this.f_58857_.m_7465_().m_44015_((RecipeType)ButchercraftRecipes.GRINDER.get(), (Container)new GrinderContainer(ingredient, attachment), this.f_58857_);
        }
        return Optional.empty();
    }

    public InteractionResult grind(Player Player2, BlockState blockState) {
        if (!this.output.m_41619_()) {
            if (this.isExtruder && this.getCasing().m_41619_()) {
                return InteractionResult.PASS;
            }
            if (this.getInsertedItem().m_41613_() < this.itemsUsed) {
                return InteractionResult.PASS;
            }
            if (this.grinds < this.grindsMax) {
                ++this.grinds;
                for (int i = 0; i < 1 + this.f_58857_.f_46441_.m_188503_(4); ++i) {
                    this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getInsertedItem()), (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.25f), 0.0, 0.0, (double)-0.1f);
                }
                this.f_58857_.m_5594_(Player2, this.f_58858_, SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                this.handler.ifPresent(item -> {
                    ItemStack in = item.getStackInSlot(0);
                    ItemStack casing = item.getStackInSlot(2);
                    if (casing != ItemStack.f_41583_) {
                        for (int i = 0; i < casing.m_41613_(); ++i) {
                            ItemStack r = this.output.m_41777_();
                            this.dropLoot(blockState, r);
                        }
                    } else {
                        ItemStack r = this.output.m_41777_();
                        this.dropLoot(blockState, r);
                    }
                    ItemStack s = in.m_41777_();
                    s.m_41764_(in.m_41613_() - this.itemsUsed);
                    item.setStackInSlot(0, ItemStack.f_41583_);
                    item.setStackInSlot(2, ItemStack.f_41583_);
                    if (item.isItemValid(0, s)) {
                        this.dropLoot(blockState, item.insertItem(0, s, false));
                    }
                });
            }
            this.updateInventory();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void dropLoot(BlockState blockState, ItemStack item) {
        Direction d = (Direction)blockState.m_61143_((Property)GrinderBlock.FACING);
        switch (d) {
            case NORTH: {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)(this.m_58899_().m_123341_() + 1), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), item, 0.0, 0.0, 0.0));
                break;
            }
            case SOUTH: {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 1.25f), item, 0.0, 0.0, (double)0.1f));
                break;
            }
            case EAST: {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() + 1), item, 0.0, 0.0, 0.0));
                break;
            }
            case WEST: {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() - 1), item, 0.0, 0.0, 0.0));
                break;
            }
        }
    }
}

