/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.butcherblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ButcherBlockSerializer
implements RecipeSerializer<ButcherBlockRecipe> {
    public ButcherBlockRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
        String group = GsonHelper.m_13851_((JsonObject)pSerializedRecipe, (String)"group", (String)"");
        NonNullList recipeItemUses = NonNullList.m_122779_();
        pSerializedRecipe.getAsJsonArray("tools").forEach(jsonElement -> recipeItemUses.add((Object)AnimatedRecipeItemUse.read(jsonElement.getAsJsonObject())));
        Ingredient carcass = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("carcass"));
        NonNullList<Ingredient> jei = ButcherBlockSerializer.itemsFromJson(pSerializedRecipe.getAsJsonArray("jei"));
        return new ButcherBlockRecipe(pRecipeId, group, carcass, (NonNullList<AnimatedRecipeItemUse>)recipeItemUses, jei);
    }

    private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < pIngredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public ButcherBlockRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String group = buffer.m_130277_();
        Ingredient carcassIn = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int listSize = buffer.m_130242_();
        NonNullList tools = NonNullList.m_122780_((int)listSize, (Object)AnimatedRecipeItemUse.EMPTY);
        tools.replaceAll(ignored -> AnimatedRecipeItemUse.read(buffer));
        int jeiSize = buffer.m_130242_();
        NonNullList jei = NonNullList.m_122780_((int)jeiSize, (Object)Ingredient.f_43901_);
        jei.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
        return new ButcherBlockRecipe(recipeId, group, carcassIn, (NonNullList<AnimatedRecipeItemUse>)tools, (NonNullList<Ingredient>)jei);
    }

    public void toNetwork(FriendlyByteBuf buffer, ButcherBlockRecipe recipe) {
        buffer.m_130070_(recipe.m_6076_());
        recipe.getCarcassIn().m_43923_(buffer);
        buffer.m_130130_(recipe.getRecipeToolsIn().size());
        recipe.getRecipeToolsIn().forEach(riu -> AnimatedRecipeItemUse.write(riu, buffer));
        buffer.m_130130_(recipe.getDummyList().size());
        recipe.getDummyList().forEach(i -> i.m_43923_(buffer));
    }
}

