/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.bases.recipes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.bases.recipes.WorkstationRecipeWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;

public class MultiToolRecipe
implements IShapedRecipe<WorkstationRecipeWrapper> {
    static int MAX_WIDTH = 5;
    static int MAX_HEIGHT = 5;
    private final RecipeType<?> type;
    private final int recipeWidth;
    private final int recipeHeight;
    private final NonNullList<Ingredient> recipeItems;
    private final NonNullList<AnimatedRecipeItemUse> recipeTools;
    private final ResourceLocation id;
    private final String group;

    public MultiToolRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, NonNullList<AnimatedRecipeItemUse> recipeToolsIn, RecipeType<?> type) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.recipeItems = recipeItemsIn;
        this.recipeTools = recipeToolsIn;
        this.type = type;
    }

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    public static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, MultiToolRecipe.firstNonSpace(s));
            int j1 = MultiToolRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static NonNullList<AnimatedRecipeItemUse> deserializeTool(JsonObject json) {
        NonNullList map = NonNullList.m_122779_();
        for (Map.Entry entry : json.entrySet()) {
            AnimatedRecipeItemUse r = AnimatedRecipeItemUse.read(((JsonElement)entry.getValue()).getAsJsonObject());
            map.add((Object)r);
        }
        return map;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = GsonHelper.m_13805_((JsonElement)object, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + s + "'");
        }
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack getRecipeOutput() {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.getRecipeItems();
    }

    public NonNullList<AnimatedRecipeItemUse> getToolList() {
        return this.getRecipeTools();
    }

    public boolean canFit(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public boolean matches(WorkstationRecipeWrapper inv, Level worldIn) {
        for (int i = 0; i <= this.recipeWidth; ++i) {
            for (int j = 0; j <= this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(WorkstationRecipeWrapper craftingInventory, int w, int h, boolean p_77573_4_) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                int k = i - w;
                int l = j - h;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (ingredient.test(craftingInventory.m_8020_(i + j * 5))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack getCraftingResult(WorkstationRecipeWrapper inv) {
        return this.getRecipeOutput().m_41777_();
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public NonNullList<Ingredient> getRecipeItems() {
        return this.recipeItems;
    }

    public int getToolListLength() {
        return this.recipeTools.size();
    }

    public NonNullList<AnimatedRecipeItemUse> getRecipeTools() {
        return this.recipeTools;
    }

    public RecipeSerializer<?> m_7707_() {
        return null;
    }

    public ItemStack assemble(WorkstationRecipeWrapper p_77572_1_, RegistryAccess registryAccess) {
        return null;
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return null;
    }
}

