/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.data;

import com.lance5057.butchercraft.Butchercraft;
import com.lance5057.butchercraft.data.builders.Advancements;
import com.lance5057.butchercraft.data.builders.BlockModels;
import com.lance5057.butchercraft.data.builders.BlockTagGenerator;
import com.lance5057.butchercraft.data.builders.ButchercraftEntityTypeTagsProvider;
import com.lance5057.butchercraft.data.builders.ButchercraftLootTableProvider;
import com.lance5057.butchercraft.data.builders.EnglishLoc;
import com.lance5057.butchercraft.data.builders.ItemModels;
import com.lance5057.butchercraft.data.builders.ItemTagGenerator;
import com.lance5057.butchercraft.data.builders.PoiTagGenerator;
import com.lance5057.butchercraft.data.builders.recipes.ButchercraftRecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="butchercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        Butchercraft.logger.info("Data Generator Started!");
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        Advancements advancements = new Advancements();
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(output, lookupProvider, existingFileHelper, List.of(advancements)));
        generator.addProvider(true, (DataProvider)new ItemModels(output, existingFileHelper));
        generator.addProvider(true, (DataProvider)new BlockModels(output, existingFileHelper));
        generator.addProvider(true, (DataProvider)new EnglishLoc(output));
        BlockTagGenerator btg = new BlockTagGenerator(output, lookupProvider, existingFileHelper);
        generator.addProvider(true, (DataProvider)btg);
        generator.addProvider(true, (DataProvider)new ItemTagGenerator(output, lookupProvider, btg.m_274426_(), existingFileHelper));
        generator.addProvider(true, (DataProvider)new ButchercraftRecipeProvider(output));
        generator.addProvider(true, (DataProvider)new ButchercraftLootTableProvider(output));
        generator.addProvider(true, (DataProvider)new ButchercraftEntityTypeTagsProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new PoiTagGenerator(output, lookupProvider, existingFileHelper));
    }
}

