/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft;

import com.lance5057.butchercraft.ButchercraftConfig;
import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.ButchercraftMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="butchercraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ButchercraftForgeEvents {
    @SubscribeEvent
    public static void giveHoodsToUndead(MobSpawnEvent.FinalizeSpawn event) {
        Mob e;
        ServerLevel level;
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel && (level = (ServerLevel)serverLevelAccessor).m_213780_().m_188501_() <= ((Double)ButchercraftConfig.HOOD_SPAWN_CHANCE.get()).floatValue() && ((e = event.getEntity()) instanceof Zombie || e instanceof Skeleton)) {
            int choice = event.getLevel().m_213780_().m_188503_(6);
            block0 : switch (choice) {
                case 0: {
                    e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.COW_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.f_20557_);
                    break;
                }
                case 1: {
                    e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.GOAT_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.f_147035_);
                    break;
                }
                case 2: {
                    e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.PIG_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.f_20510_);
                    break;
                }
                case 3: {
                    e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.SHEEP_HOOD.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.f_20520_);
                    break;
                }
                case 4: {
                    e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.CHICKEN_MASK.get()));
                    ButchercraftForgeEvents.spawnArmy(level, e, EntityType.f_20555_);
                    break;
                }
                default: {
                    int rabbit = event.getLevel().m_213780_().m_188503_(6);
                    switch (rabbit) {
                        case 0: {
                            e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.BLACK_BUNNY_EARS.get()));
                            e.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.BLACK_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.f_20517_, Rabbit.Variant.BLACK);
                            break block0;
                        }
                        case 1: {
                            e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.BROWN_BUNNY_EARS.get()));
                            e.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.BROWN_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.f_20517_, Rabbit.Variant.BROWN);
                            break block0;
                        }
                        case 2: {
                            e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.GOLD_BUNNY_EARS.get()));
                            e.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.GOLD_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.f_20517_, Rabbit.Variant.GOLD);
                            break block0;
                        }
                        case 3: {
                            e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.SALT_BUNNY_EARS.get()));
                            e.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.SALT_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.f_20517_, Rabbit.Variant.SALT);
                            break block0;
                        }
                        case 4: {
                            e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_EARS.get()));
                            e.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_TAIL.get()));
                            ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.f_20517_, Rabbit.Variant.WHITE_SPLOTCHED);
                            break block0;
                        }
                    }
                    e.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ButchercraftItems.WHITE_BUNNY_EARS.get()));
                    e.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ButchercraftItems.WHITE_BUNNY_TAIL.get()));
                    ButchercraftForgeEvents.spawnRabbitArmy(level, e, EntityType.f_20517_, Rabbit.Variant.WHITE);
                }
            }
        }
    }

    private static void spawnArmy(ServerLevel level, Mob e, EntityType<?> type) {
        if (level.m_46472_() == Level.f_46428_ && level.m_45527_(e.m_20183_()) && level.m_213780_().m_188501_() <= ((Double)ButchercraftConfig.HOOD_ARMY_CHANCE.get()).floatValue()) {
            int animalsAmount = level.m_213780_().m_188503_(4) + 2;
            for (int i = 0; i < animalsAmount; ++i) {
                Animal ent = (Animal)type.m_262455_(level, (CompoundTag)null, null, e.m_20183_().m_7918_(level.m_213780_().m_188503_(6) - 3, 0, level.m_213780_().m_188503_(6) - 3), MobSpawnType.EVENT, false, false);
                ent.m_7292_(new MobEffectInstance((MobEffect)ButchercraftMobEffects.BLOODLUST.get(), 3600));
            }
        }
    }

    private static void spawnRabbitArmy(ServerLevel level, Mob e, EntityType<?> type, Rabbit.Variant skin) {
        if (level.m_46472_() == Level.f_46428_ && level.m_45527_(e.m_20183_()) && level.m_213780_().m_188501_() <= ((Double)ButchercraftConfig.HOOD_ARMY_CHANCE.get()).floatValue()) {
            int animalsAmount = level.m_213780_().m_188503_(4) + 2;
            for (int i = 0; i < animalsAmount; ++i) {
                Rabbit ent = (Rabbit)type.m_262455_(level, (CompoundTag)null, null, e.m_20183_().m_7918_(level.m_213780_().m_188503_(6) - 3, 0, level.m_213780_().m_188503_(6) - 3), MobSpawnType.EVENT, false, false);
                ent.m_28464_(skin);
                ent.m_7292_(new MobEffectInstance((MobEffect)ButchercraftMobEffects.BLOODLUST.get(), 3600));
            }
        }
    }

    @SubscribeEvent
    public static void bloodyTrail(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof Zombie) {
            Zombie z = (Zombie)mob;
            for (Player p : event.getLevel().m_6907_()) {
                if (!p.m_21023_((MobEffect)ButchercraftMobEffects.BLOODTRAIL.get())) continue;
                z.m_6710_((LivingEntity)p);
            }
        }
    }
}

