/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft;

import com.lance5057.butchercraft.ButchercraftBlocks;
import com.lance5057.butchercraft.ButchercraftItems;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.antlr.v4.runtime.misc.NotNull;
import org.joml.Vector3f;

public class ButchercraftFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"butchercraft");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"butchercraft");
    public static final RegistryObject<FluidType> BLOOD_FLUID_TYPE = FLUID_TYPES.register("blood_fluid", () -> new FluidType(FluidType.Properties.create().supportsBoating(true).canHydrate(true).density(2000).viscosity(3000).fallDistanceModifier(0.0f).canExtinguish(true)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation STILL = new ResourceLocation("block/water_still");
                private static final ResourceLocation FLOW = new ResourceLocation("block/water_flow");
                private static final ResourceLocation OVERLAY = new ResourceLocation("block/water_still");
                private static final ResourceLocation VIEW_OVERLAY = new ResourceLocation("textures/block/water_still.png");

                public ResourceLocation getStillTexture() {
                    return STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOW;
                }

                public ResourceLocation getOverlayTexture() {
                    return OVERLAY;
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return VIEW_OVERLAY;
                }

                public int getTintColor() {
                    return -1353446908;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    int color = this.getTintColor();
                    return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    nearDistance = -48.0f;
                    farDistance = 24.0f;
                    if (farDistance > renderDistance) {
                        farDistance = renderDistance;
                        shape = FogShape.CYLINDER;
                    }
                    RenderSystem.setShaderFogStart((float)nearDistance);
                    RenderSystem.setShaderFogEnd((float)farDistance);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }
            });
        }
    });
    public static final RegistryObject<FlowingFluid> BLOOD_FLUID = FLUIDS.register("blood_fluid", () -> new ForgeFlowingFluid.Source(ButchercraftFluids.blood()));
    public static final RegistryObject<Fluid> BLOOD_FLUID_FLOWING = FLUIDS.register("blood_fluid_flowing", () -> new ForgeFlowingFluid.Flowing(ButchercraftFluids.blood()));

    private static ForgeFlowingFluid.Properties blood() {
        return new ForgeFlowingFluid.Properties(BLOOD_FLUID_TYPE, BLOOD_FLUID, BLOOD_FLUID_FLOWING).block(ButchercraftBlocks.BLOOD_FLUID_BLOCK).bucket(ButchercraftItems.BLOOD_FLUID_BUCKET);
    }

    public static void register(IEventBus modBus) {
        FLUID_TYPES.register(modBus);
        FLUIDS.register(modBus);
    }
}

