/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.GuiBuilderWrapper;
import de.mrjulsen.crn.block.display.properties.components.IStaticTextSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextBackgroundColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextPosSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextScaleSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextWidthSetting;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class StaticTextDisplaySettings
extends BasicDisplaySettings
implements IStaticTextSetting,
ITextScaleSetting,
ITextPosSetting,
ITextWidthSetting,
ITextBackgroundColorSetting {
    public static final byte MAX_COMPONENTS = 50;
    private static final String NBT_COMPONENTS = "Components";
    private static final String NBT_SELECTED_COMPONENT = "SelectedComponent";
    private final List<TextComponent> components = new ArrayList<TextComponent>();
    protected byte selectedComponent = 0;

    public StaticTextDisplaySettings() {
        this.components.add(new TextComponent("Hello World"));
    }

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.m_128441_(NBT_COMPONENTS)) {
            this.components.clear();
            this.components.addAll(nbt.m_128437_(NBT_COMPONENTS, 10).stream().map(x -> TextComponent.fromNbt((CompoundTag)x)).toList());
        }
        if (nbt.m_128441_(NBT_SELECTED_COMPONENT)) {
            this.selectedComponent = nbt.m_128445_(NBT_SELECTED_COMPONENT);
        }
        if (this.components.isEmpty()) {
            this.components.add(new TextComponent("Hello World"));
        }
        this.verifyComponents();
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        this.verifyComponents();
        super.serializeNbt(nbt);
        ListTag list = new ListTag();
        int k = 0;
        for (TextComponent component : this.components) {
            list.add((Object)component.toNbt());
            if (++k < 50) continue;
            break;
        }
        nbt.m_128365_(NBT_COMPONENTS, (Tag)list);
        nbt.m_128344_(NBT_SELECTED_COMPONENT, this.selectedComponent);
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        GuiBuilderWrapper.buildStaticTextBaseGui(this, context);
        this.buildStaticTextGui(context);
        this.buildTextPosGui(context);
        this.buildTextScaleGui(context);
        this.buildTextMaxWidthGui(context);
        this.buildTextBackgroundColorGui(context);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        currentIndex = this.getSelectedComponentIndex();
        if (!(oldSettings instanceof StaticTextDisplaySettings)) ** GOTO lbl-1000
        o = (StaticTextDisplaySettings)oldSettings;
        if (!o.components.isEmpty() && this != o) {
            this.components.clear();
            for (i = 0; i < o.getComponentsCount(); i = (int)((byte)(i + 1))) {
                this.components.add(new TextComponent());
                this.selectedComponent = (byte)i;
                o.selectedComponent = (byte)i;
                this.copyStaticTextSettings(oldSettings);
                this.copyTextScaleSettings(oldSettings);
                this.copyTextPosSettings(oldSettings);
                this.copyTextMaxWidthSetting(oldSettings);
                this.copyTextBackgroundColorSettings(oldSettings);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.copyStaticTextSettings(oldSettings);
            this.copyTextScaleSettings(oldSettings);
            this.copyTextPosSettings(oldSettings);
            this.copyTextMaxWidthSetting(oldSettings);
            this.copyTextBackgroundColorSettings(oldSettings);
        }
        this.setSelectedComponentIndex(currentIndex);
    }

    public TextComponent getSelectedComponent() {
        return this.components.isEmpty() ? new TextComponent() : this.components.get(MathUtils.clamp((int)this.selectedComponent, (int)0, (int)(this.components.size() - 1)));
    }

    public List<TextComponent> getComponents() {
        return ImmutableList.copyOf(this.components);
    }

    public void addComponent(TextComponent component) {
        this.components.add(component);
        this.verifyComponents();
    }

    public void setComponent(int index, TextComponent component) {
        this.components.set(index, component);
    }

    public int getComponentsCount() {
        return this.components.size();
    }

    public byte getSelectedComponentIndex() {
        return this.selectedComponent;
    }

    public void setSelectedComponentIndex(int index) {
        this.selectedComponent = (byte)MathUtils.clamp((int)index, (int)0, (int)(this.components.size() - 1));
    }

    @Override
    public String getStaticText() {
        return this.getSelectedComponent().staticText;
    }

    @Override
    public void setStaticText(String text) {
        this.getSelectedComponent().staticText = text;
    }

    @Override
    public float getXScale() {
        return this.getSelectedComponent().xScale;
    }

    @Override
    public void setXScale(float xScale) {
        this.getSelectedComponent().xScale = xScale;
    }

    @Override
    public float getYScale() {
        return this.getSelectedComponent().yScale;
    }

    @Override
    public void setYScale(float f) {
        this.getSelectedComponent().yScale = f;
    }

    @Override
    public float getMinXScale() {
        return this.getSelectedComponent().minXScale;
    }

    @Override
    public void setMinXScale(float f) {
        this.getSelectedComponent().minXScale = f;
    }

    @Override
    public ITextWidthSetting.TextScaleBounds getBoundsAction() {
        return this.getSelectedComponent().bounds;
    }

    @Override
    public void setBoundsAction(ITextWidthSetting.TextScaleBounds action) {
        this.getSelectedComponent().bounds = action;
    }

    @Override
    public float getX() {
        return this.getSelectedComponent().x;
    }

    @Override
    public void setX(float x) {
        this.getSelectedComponent().x = x;
    }

    @Override
    public float getY() {
        return this.getSelectedComponent().y;
    }

    @Override
    public void setY(float y) {
        this.getSelectedComponent().y = y;
    }

    @Override
    public EAlignment getTextAlignment() {
        return this.getSelectedComponent().alignment;
    }

    @Override
    public void setTextAlignment(EAlignment alignment) {
        this.getSelectedComponent().alignment = alignment;
    }

    @Override
    public float getTextMaxWidth() {
        return this.getSelectedComponent().maxWidth;
    }

    @Override
    public void setTextMaxWidth(float s) {
        this.getSelectedComponent().maxWidth = s;
    }

    @Override
    public int getTextBackgroundColor() {
        return this.getSelectedComponent().backgroundColor;
    }

    @Override
    public void setTextBackgroundColor(int color) {
        this.getSelectedComponent().backgroundColor = color;
    }

    @Override
    public boolean isFullLabelBackgroundColor() {
        return this.getSelectedComponent().fullLabelColor;
    }

    @Override
    public void setFullLabelBackgroundColor(boolean b) {
        this.getSelectedComponent().fullLabelColor = b;
    }

    public void verifyComponents() {
        int k;
        TextComponent current = this.getSelectedComponentIndex() > 0 && this.getSelectedComponentIndex() < this.components.size() ? this.components.get(this.getSelectedComponentIndex()) : null;
        Iterator<TextComponent> components = this.components.iterator();
        int i = 1;
        while (components.hasNext()) {
            TextComponent comp = components.next();
            if (i > 50 || comp.staticText == null || comp.staticText.isBlank()) {
                components.remove();
            }
            ++i;
        }
        int n = k = current == null ? -1 : this.components.indexOf(current);
        if (k < 0) {
            this.setSelectedComponentIndex(this.getSelectedComponentIndex());
        }
    }

    public void createNewComponent() {
        if (this.components.size() < 50) {
            this.components.add(new TextComponent());
        }
    }

    public static class TextComponent {
        String staticText = "";
        float xScale = 0.75f;
        float yScale = 0.75f;
        float minXScale = 0.75f;
        ITextWidthSetting.TextScaleBounds bounds = ITextWidthSetting.DEFAULT_BOUNDS_ACTION;
        float x = 0.0f;
        float y = 2.5f;
        float maxWidth = 250.0f;
        EAlignment alignment = ITextPosSetting.DEFAULT_TEXT_ALIGNMENT;
        int backgroundColor = 0;
        boolean fullLabelColor = false;

        public TextComponent() {
        }

        public TextComponent(String text) {
            this.staticText = text;
        }

        public String getStaticText() {
            return this.staticText;
        }

        public void setStaticText(String text) {
            this.staticText = text == null ? "" : text;
        }

        public float getXScale() {
            return this.xScale;
        }

        public void setXScale(float xScale) {
            this.xScale = xScale;
        }

        public float getYScale() {
            return this.yScale;
        }

        public void setYScale(float f) {
            this.yScale = f;
        }

        public float getMinXScale() {
            return this.minXScale;
        }

        public void setMinXScale(float f) {
            this.minXScale = f;
        }

        public ITextWidthSetting.TextScaleBounds getBoundsAction() {
            return this.bounds;
        }

        public void setBoundsAction(ITextWidthSetting.TextScaleBounds action) {
            this.bounds = action;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public EAlignment getTextAlignment() {
            return this.alignment;
        }

        public void setTextAlignment(EAlignment alignment) {
            this.alignment = alignment;
        }

        public float getTextMaxWidth() {
            return this.maxWidth;
        }

        public void setTextMaxWidth(float s) {
            this.maxWidth = s;
        }

        public int getTextBackgroundColor() {
            return this.backgroundColor;
        }

        public void setTextBackgroundColor(int color) {
            this.backgroundColor = color;
        }

        public boolean isFullLabelBackgroundColor() {
            return this.fullLabelColor;
        }

        public void setFullLabelBackgroundColor(boolean b) {
            this.fullLabelColor = b;
        }

        public static TextComponent fromNbt(CompoundTag nbt) {
            TextComponent comp = new TextComponent();
            if (nbt.m_128441_("StaticText")) {
                comp.staticText = nbt.m_128461_("StaticText");
            }
            if (nbt.m_128441_("XScale")) {
                comp.xScale = nbt.m_128457_("XScale");
            }
            if (nbt.m_128441_("YScale")) {
                comp.yScale = nbt.m_128457_("YScale");
            }
            if (nbt.m_128441_("MinXScale")) {
                comp.minXScale = nbt.m_128457_("MinXScale");
            }
            if (nbt.m_128441_("BoundsAction")) {
                comp.bounds = ITextWidthSetting.TextScaleBounds.getByIndex(nbt.m_128445_("BoundsAction"));
            }
            if (nbt.m_128441_("PosX")) {
                comp.x = nbt.m_128457_("PosX");
            }
            if (nbt.m_128441_("PosY")) {
                comp.y = nbt.m_128457_("PosY");
            }
            if (nbt.m_128441_("TextMaxWidth")) {
                comp.maxWidth = nbt.m_128457_("TextMaxWidth");
            }
            if (nbt.m_128441_("TextAlignment")) {
                comp.alignment = EAlignment.getById((int)nbt.m_128451_("TextAlignment"));
            }
            if (nbt.m_128441_("TextBackgroundColor")) {
                comp.backgroundColor = nbt.m_128451_("TextBackgroundColor");
            }
            if (nbt.m_128441_("FullLabelBackgroundColor")) {
                comp.fullLabelColor = nbt.m_128471_("FullLabelBackgroundColor");
            }
            return comp;
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("StaticText", this.staticText);
            nbt.m_128350_("XScale", this.xScale);
            nbt.m_128350_("YScale", this.yScale);
            nbt.m_128350_("MinXScale", this.minXScale);
            nbt.m_128344_("BoundsAction", this.bounds.getIndex());
            nbt.m_128350_("PosX", this.x);
            nbt.m_128350_("PosY", this.y);
            nbt.m_128350_("TextMaxWidth", this.maxWidth);
            nbt.m_128405_("TextAlignment", this.alignment.getId());
            nbt.m_128405_("TextBackgroundColor", this.backgroundColor);
            nbt.m_128379_("FullLabelBackgroundColor", this.fullLabelColor);
            return nbt;
        }

        public String toString() {
            return this.staticText;
        }
    }
}

