/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.event.IClientConnectionEvent;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.client.util.VanillaTextures;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModCreativeTabs;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;

public class CreativeFilters {
    private static CreativeFilters instance;
    private final List<FilterCategory> categories;
    private AbstractWidget scrollUpButton;
    private AbstractWidget scrollDownButton;
    private CreativeModeTab lastTab;
    private int guiLeft;
    private int guiTop;
    private int scroll;

    public static CreativeFilters get() {
        if (instance == null) {
            instance = new CreativeFilters();
        }
        return instance;
    }

    private CreativeFilters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new FilterCategory(ModTags.Items.GENERAL, new ItemStack((ItemLike)ModBlocks.CHAIR_OAK.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.BEDROOM, new ItemStack((ItemLike)ModBlocks.DRAWER_CHERRY.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.KITCHEN, new ItemStack((ItemLike)ModBlocks.KITCHEN_SINK_YELLOW.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.OUTDOORS, new ItemStack((ItemLike)ModBlocks.GRILL_RED.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.BATHROOM, new ItemStack((ItemLike)ModBlocks.TOILET_OAK.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.ELECTRONICS, new ItemStack((ItemLike)ModBlocks.ELECTRICITY_GENERATOR_LIGHT.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.STORAGE, new ItemStack((ItemLike)ModBlocks.CRATE_BIRCH.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.FOOD, new ItemStack((ItemLike)ModItems.SWEET_BERRY_JAM_TOAST.get())));
        builder.add((Object)new FilterCategory(ModTags.Items.ITEMS, new ItemStack((ItemLike)ModItems.SPATULA.get())));
        this.categories = builder.build();
        ScreenEvents.MODIFY_WIDGETS.register((IFrameworkEvent)((IScreenEvent.ModifyWidgets)(screen, widgets, add, remove) -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                this.guiLeft = ClientServices.PLATFORM.getGuiLeft((AbstractContainerScreen<?>)creativeScreen);
                this.guiTop = ClientServices.PLATFORM.getGuiTop((AbstractContainerScreen<?>)creativeScreen);
                this.categories.forEach(FilterCategory::loadItems);
                this.injectWidgets(creativeScreen, add);
            }
        }));
        ScreenEvents.CLOSED.register((IFrameworkEvent)((IScreenEvent.Closed)screen -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                this.categories.forEach(category -> {
                    this.scrollUpButton = null;
                    this.scrollDownButton = null;
                    category.setFilterTab(null);
                });
            }
        }));
        ScreenEvents.AFTER_DRAW.register((IFrameworkEvent)((IScreenEvent.AfterDraw)(screen, graphics, mouseX, mouseY, partialTick) -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                CreativeModeTab tab = ClientServices.PLATFORM.getSelectedCreativeModeTab();
                if (this.lastTab != tab) {
                    this.onSwitchCreativeTab(tab, creativeScreen);
                    this.lastTab = tab;
                }
            }
        }));
        ClientConnectionEvents.LOGGING_OUT.register((IFrameworkEvent)((IClientConnectionEvent.LoggingOut)player -> this.categories.forEach(category -> {
            category.resetItems();
            category.setEnabled(true);
        })));
    }

    private void injectWidgets(CreativeModeInventoryScreen screen, Consumer<AbstractWidget> add) {
        this.categories.forEach(category -> {
            FilterTab tab = new FilterTab(this.guiLeft - 28, this.guiTop, (FilterCategory)category, btn -> {
                if (Screen.m_96637_() || Screen.m_96638_()) {
                    category.setEnabled(!category.isEnabled());
                } else {
                    this.categories.forEach(c -> c.setEnabled(false));
                    category.setEnabled(true);
                }
                this.updateItems(screen);
            });
            tab.f_93624_ = false;
            add.accept((AbstractWidget)tab);
        });
        this.scrollUpButton = new IconButton(this.guiLeft - 22, this.guiTop - 12, 0, 0, btn -> {
            if (this.scroll > 0) {
                --this.scroll;
            }
            this.updateWidgets();
        });
        add.accept(this.scrollUpButton);
        this.scrollDownButton = new IconButton(this.guiLeft - 22, this.guiTop + 127, 10, 0, btn -> {
            if (this.scroll <= this.categories.size() - 4 - 1) {
                ++this.scroll;
            }
            this.updateWidgets();
        });
        add.accept(this.scrollDownButton);
        this.updateWidgets();
        this.onSwitchCreativeTab(ClientServices.PLATFORM.getSelectedCreativeModeTab(), screen);
    }

    private void updateItems(CreativeModeInventoryScreen screen) {
        HashSet seenItems = new HashSet();
        LinkedHashSet categorisedItems = new LinkedHashSet();
        ((CreativeModeTab)ModCreativeTabs.MAIN.get()).m_260957_().forEach(stack -> this.categories.stream().filter(FilterCategory::isEnabled).forEach(category -> {
            Item item = stack.m_41720_();
            if (!seenItems.contains(item) && stack.m_204117_(category.tag)) {
                categorisedItems.add(stack.m_41777_());
                seenItems.add(item);
            }
        }));
        NonNullList items = ((CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_()).f_98639_;
        items.clear();
        items.addAll(categorisedItems);
        ((CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_()).m_98642_(0.0f);
    }

    private void updateWidgets() {
        this.categories.forEach(category -> category.setVisible(false));
        for (int i = this.scroll; i < this.scroll + 4 && i < this.categories.size(); ++i) {
            FilterCategory category2 = this.categories.get(i);
            category2.setY(this.guiTop + 29 * (i - this.scroll) + 11);
            category2.setVisible(true);
        }
        this.scrollUpButton.f_93623_ = this.scroll > 0;
        this.scrollDownButton.f_93623_ = this.scroll <= this.categories.size() - 4 - 1;
    }

    private void onSwitchCreativeTab(CreativeModeTab tab, CreativeModeInventoryScreen screen) {
        boolean isFurnitureTab;
        this.scrollUpButton.f_93624_ = isFurnitureTab = tab == ModCreativeTabs.MAIN.get();
        this.scrollDownButton.f_93624_ = isFurnitureTab;
        if (isFurnitureTab) {
            this.updateWidgets();
            this.updateItems(screen);
            return;
        }
        this.categories.forEach(category -> category.setVisible(false));
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double scroll) {
        CreativeModeTab selectedTab = ClientServices.PLATFORM.getSelectedCreativeModeTab();
        if (selectedTab != ModCreativeTabs.MAIN.get()) {
            return false;
        }
        double startX = this.guiLeft - 28;
        double startY = this.guiTop + 29;
        if (mouseX >= startX && mouseX < startX + 28.0 && mouseY >= startY && mouseY < startY + 113.0) {
            int oldScroll = this.scroll;
            this.scroll += scroll > 0.0 ? -1 : 1;
            this.scroll = Mth.m_14045_((int)this.scroll, (int)0, (int)(this.categories.size() - 4));
            if (this.scroll != oldScroll) {
                this.updateWidgets();
            }
            return true;
        }
        return false;
    }

    public static class FilterCategory {
        private final TagKey<Item> tag;
        private final ItemStack icon;
        private List<Item> items;
        private boolean enabled = true;
        @Nullable
        private FilterTab filterTab;

        public FilterCategory(TagKey<Item> tag, ItemStack icon) {
            this.tag = tag;
            this.icon = icon;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public Optional<List<Item>> getItems() {
            return Optional.ofNullable(this.items);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setFilterTab(@Nullable FilterTab filterTab) {
            this.filterTab = filterTab;
        }

        public void setVisible(boolean visible) {
            if (this.filterTab != null) {
                this.filterTab.f_93624_ = visible;
            }
        }

        public void setY(int y) {
            if (this.filterTab != null) {
                this.filterTab.m_253211_(y);
            }
        }

        public void loadItems() {
            if (this.items != null) {
                return;
            }
            this.items = new ArrayList<Item>();
            BuiltInRegistries.f_257033_.m_123024_().forEach(item -> {
                if (item.m_204114_().m_203656_(this.getTag())) {
                    this.items.add((Item)item);
                }
            });
        }

        public void resetItems() {
            this.items = null;
        }
    }

    private static class FilterTab
    extends Button {
        private final FilterCategory category;

        protected FilterTab(int x, int y, FilterCategory category, Button.OnPress onPress) {
            super(x, y, 32, 26, CommonComponents.f_237098_, onPress, f_252438_);
            this.category = category;
            category.setFilterTab(this);
            ResourceLocation tagId = category.getTag().f_203868_();
            String tooltipTitle = String.format("filterCategory.%s.%s", tagId.m_135827_(), tagId.m_135815_().replace("/", "."));
            String tooltipDesc = tooltipTitle + ".desc";
            this.m_257544_(ScreenHelper.createMultilineTooltip(List.of(Component.m_237115_((String)tooltipTitle), Component.m_237115_((String)tooltipDesc).m_130940_(ChatFormatting.GRAY))));
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int textureX = 26;
            int textureY = this.category.isEnabled() ? 32 : 0;
            int textureWidth = this.category.isEnabled() ? 32 : 28;
            int textureHeight = 26;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)VanillaTextures.CREATIVE_TABS);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            this.drawRotatedTexture(graphics.m_280168_().m_85850_().m_252922_(), this.m_252754_(), this.m_252907_(), textureX, textureY, textureWidth, textureHeight);
            graphics.m_280480_(this.category.getIcon(), this.m_252754_() + 8, this.m_252907_() + 5);
        }

        private void drawRotatedTexture(Matrix4f matrix4f, int x, int y, int textureX, int textureY, int textureWidth, int textureHeight) {
            float scaleX = 0.00390625f;
            float scaleY = 0.00390625f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            BufferBuilder builder = Tesselator.m_85913_().m_85915_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            builder.m_252986_(matrix4f, (float)x, (float)(y + textureHeight), 0.0f).m_7421_((float)(textureX + textureHeight) * scaleX, (float)textureY * scaleY).m_5752_();
            builder.m_252986_(matrix4f, (float)(x + textureWidth), (float)(y + textureHeight), 0.0f).m_7421_((float)(textureX + textureHeight) * scaleX, ((float)textureY + (float)textureWidth) * scaleY).m_5752_();
            builder.m_252986_(matrix4f, (float)(x + textureWidth), (float)y, 0.0f).m_7421_((float)textureX * scaleX, (float)(textureY + textureWidth) * scaleY).m_5752_();
            builder.m_252986_(matrix4f, (float)x, (float)y, 0.0f).m_7421_((float)textureX * scaleX, (float)textureY * scaleY).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        }

        protected ClientTooltipPositioner m_262860_() {
            return DefaultTooltipPositioner.f_262752_;
        }
    }
}

