/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CuttingBoardBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private final WoodType type;

    public CuttingBoardBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0, (double)15.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> VoxelShapeHelper.rotateHorizontally(baseShape, (Direction)state.m_61143_((Property)DIRECTION)))));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CuttingBoardBlockEntity) {
            CuttingBoardBlockEntity cuttingBoard = (CuttingBoardBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (heldItem.m_204117_(Services.TAG.getToolKnivesTag())) {
                boolean dropAsEntity;
                boolean bl = dropAsEntity = !Services.ENTITY.isFakePlayer(player);
                if (cuttingBoard.sliceItem(level, dropAsEntity)) {
                    if (!level.m_5776_()) {
                        heldItem.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            } else if (cuttingBoard.placeItem(heldItem)) {
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CuttingBoardBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.m_5776_()) {
            return CuttingBoardBlock.createTicker(type, (BlockEntityType)ModBlockEntities.CUTTING_BOARD.get(), CuttingBoardBlockEntity::serverTick);
        }
        return null;
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144280_);
    }
}

