/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class HoneycombHoleProcessor
extends StructureProcessor {
    public static final Codec<HoneycombHoleProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("flood_level").forGetter(config -> config.floodLevel)).apply((Applicative)instance, instance.stable(HoneycombHoleProcessor::new)));
    private final int floodLevel;

    private HoneycombHoleProcessor(int floodLevel) {
        this.floodLevel = floodLevel;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        RandomSource random;
        BlockPos worldPos = structureBlockInfoWorld.f_74675_();
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, worldPos)) {
            return structureBlockInfoWorld;
        }
        BlockState placingState = structureBlockInfoWorld.f_74676_();
        ChunkAccess chunk = levelReader.m_46865_(worldPos);
        LevelChunkSection chunkSection = chunk.m_183278_(levelReader.m_151564_(worldPos.m_123342_()));
        BlockState checkedState = HoneycombHoleProcessor.getBlockStateFromSection(chunkSection, worldPos);
        if (checkedState.m_60795_() || !checkedState.m_60819_().m_76178_()) {
            if (placingState.m_60795_() || placingState.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
                if (!checkedState.m_60819_().m_76178_() || worldPos.m_123342_() <= this.floodLevel) {
                    HoneycombHoleProcessor.setBlockStateFromSection(chunkSection, worldPos, BzFluids.SUGAR_WATER_BLOCK.get().m_49966_());
                    if (checkedState.m_155947_()) {
                        chunk.m_8114_(worldPos);
                    }
                    return null;
                }
            } else {
                return null;
            }
        }
        if (placingState.m_60713_(BzBlocks.HONEYCOMB_BROOD.get())) {
            RandomSource random2;
            if (checkedState.m_155947_()) {
                chunk.m_8114_(worldPos);
            }
            if ((random2 = settings.m_230326_(worldPos)).m_188503_(5) < 2) {
                return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)placingState.m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random2.m_188503_(3))), null);
            }
            if (random2.m_188503_(13) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)BzBlocks.EMPTY_HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)EmptyHoneycombBrood.f_52588_, (Comparable)((Direction)placingState.m_61143_((Property)HoneycombBrood.f_52588_))), null);
            }
            if (random2.m_188503_(4) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.f_50719_.m_49966_(), null);
        }
        if (placingState.m_60713_(Blocks.f_50719_) || placingState.m_60713_(BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            RandomSource random3;
            if (checkedState.m_155947_()) {
                chunk.m_8114_(worldPos);
            }
            if ((random3 = settings.m_230326_(worldPos)).m_188503_(3) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.f_50719_.m_49966_(), null);
        }
        if (placingState.m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
            RandomSource random4;
            BlockState belowState = chunk.m_8055_(worldPos.m_7495_());
            if (belowState.m_60795_() || !belowState.m_60819_().m_76178_()) {
                return null;
            }
            if (checkedState.m_155947_()) {
                chunk.m_8114_(worldPos);
            }
            if ((random4 = settings.m_230326_(worldPos)).m_188503_(80) != 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.f_50627_.m_49966_(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)BzBlocks.PILE_OF_POLLEN.get().m_49966_().m_61124_((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(random4.m_188503_(3) + 1)), null);
        }
        if (placingState.m_60713_(Blocks.f_50720_) && (random = settings.m_230326_(worldPos)).m_188503_(3) != 0) {
            if (checkedState.m_155947_()) {
                chunk.m_8114_(worldPos);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), null);
        }
        if (checkedState.m_155947_()) {
            chunk.m_8114_(worldPos);
        }
        return structureBlockInfoWorld;
    }

    private static BlockState getBlockStateFromSection(LevelChunkSection chunkSection, BlockPos blockPos) {
        int i = SectionPos.m_123207_((int)blockPos.m_123341_());
        int j = SectionPos.m_123207_((int)blockPos.m_123342_());
        int k = SectionPos.m_123207_((int)blockPos.m_123343_());
        return chunkSection.m_62982_(i, j, k);
    }

    private static void setBlockStateFromSection(LevelChunkSection chunkSection, BlockPos blockPos, BlockState newState) {
        int i = SectionPos.m_123207_((int)blockPos.m_123341_());
        int j = SectionPos.m_123207_((int)blockPos.m_123342_());
        int k = SectionPos.m_123207_((int)blockPos.m_123343_());
        chunkSection.m_62986_(i, j, k, newState);
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.HONEYCOMB_HOLE_PROCESSOR.get();
    }
}

