/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureDisallowByTag
extends PlacementModifier {
    private final Optional<TagKey<Structure>> disallowTag;
    private final boolean piecewiseCheck;
    public static final Codec<StructureDisallowByTag> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256944_).optionalFieldOf("disallow_tag").forGetter(structureDisallowByTag -> structureDisallowByTag.disallowTag), (App)Codec.BOOL.fieldOf("piecewise_check").forGetter(structureDisallowByTag -> structureDisallowByTag.piecewiseCheck)).apply((Applicative)configInstance, StructureDisallowByTag::new));

    private StructureDisallowByTag(Optional<TagKey<Structure>> disallowTag, boolean piecewiseCheck) {
        this.disallowTag = disallowTag;
        this.piecewiseCheck = piecewiseCheck;
    }

    public PlacementModifierType<?> m_183327_() {
        return BzPlacements.STRUCTURE_DISALLOW_BY_TAG.get();
    }

    public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        WorldGenLevel worldGenLevel = placementContext.m_191831_();
        if (worldGenLevel instanceof WorldGenRegion) {
            List structureStarts;
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            Registry structureRegistry = (Registry)worldGenRegion.m_9598_().m_6632_(Registries.f_256944_).get();
            StructureManager structureManager = ((WorldGenRegionAccessor)worldGenRegion).bumblezone$getStructureManager();
            ChunkPos chunkPos = new ChunkPos(blockPos);
            if (this.disallowTag.isPresent() && !(structureStarts = structureManager.m_220477_(chunkPos, struct -> structureRegistry.m_246971_((ResourceKey)structureRegistry.m_7854_(struct).get()).m_203656_(this.disallowTag.get()))).isEmpty()) {
                boolean validSpot = true;
                if (this.piecewiseCheck) {
                    block0: for (StructureStart structureStart : structureStarts) {
                        for (StructurePiece structurePiece : structureStart.m_73602_()) {
                            if (!structurePiece.m_73547_().m_191961_(8).m_71051_((Vec3i)blockPos)) continue;
                            validSpot = false;
                            continue block0;
                        }
                    }
                } else {
                    for (StructureStart structureStart : structureStarts) {
                        if (!structureStart.m_73603_() || !structureStart.m_73601_().m_191961_(8).m_71051_((Vec3i)blockPos)) continue;
                        validSpot = false;
                        break;
                    }
                }
                if (!validSpot) {
                    return Stream.empty();
                }
            }
        }
        return Stream.of(blockPos);
    }
}

