/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.TwoToneSpikeFeatureConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.Structure;

public class TwoToneSpikeFeature
extends Feature<TwoToneSpikeFeatureConfig> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public TwoToneSpikeFeature(Codec<TwoToneSpikeFeatureConfig> configFactory) {
        super(configFactory);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public boolean m_142674_(FeaturePlaceContext<TwoToneSpikeFeatureConfig> context) {
        BlockState state;
        this.setSeed(context.m_159774_().m_7328_());
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        if (level.m_8055_(origin).m_60815_()) {
            return false;
        }
        Registry structureRegistry = (Registry)context.m_159774_().m_9598_().m_6632_(Registries.f_256944_).get();
        if (context.m_159774_() instanceof WorldGenRegion) {
            Structure thronePillar;
            StructureManager structureManager = ((WorldGenRegionAccessor)context.m_159774_()).bumblezone$getStructureManager();
            if (origin.m_123342_() > 130 && origin.m_123342_() < 148 && (thronePillar = (Structure)structureRegistry.m_7745_(new ResourceLocation("the_bumblezone", "throne_pillar"))) != null && structureManager.m_220494_(origin, thronePillar).m_73603_()) {
                return false;
            }
            Optional optionalHolders = structureRegistry.m_203431_(BzTags.NO_GIANT_SPIKES);
            if (optionalHolders.isPresent()) {
                for (Holder structureHolder : (HolderSet.Named)optionalHolders.get()) {
                    if (!structureManager.m_220494_(origin, (Structure)structureHolder.m_203334_()).m_73603_()) continue;
                    return false;
                }
            }
        }
        boolean validSpot = false;
        boolean superSlant = false;
        Object wallDirection = null;
        BlockState attachedState = null;
        for (Direction direction : Direction.Plane.VERTICAL) {
            blockpos$Mutable.m_122190_((Vec3i)origin).m_122175_(direction, 5);
            state = level.m_8055_((BlockPos)blockpos$Mutable);
            if (!state.m_60815_()) continue;
            validSpot = true;
            attachedState = state;
            break;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$Mutable.m_122190_((Vec3i)origin).m_122175_(direction, 1);
            state = level.m_8055_((BlockPos)blockpos$Mutable);
            if (!state.m_60815_()) continue;
            validSpot = true;
            attachedState = state;
        }
        if (!validSpot) {
            return false;
        }
        if (!attachedState.m_204336_(((TwoToneSpikeFeatureConfig)context.m_159778_()).allowedBaseBlockCopies)) {
            return false;
        }
        blockpos$Mutable.m_122190_((Vec3i)origin).m_122175_(Direction.UP, 5);
        int directionSign = level.m_8055_((BlockPos)blockpos$Mutable).m_60815_() ? -1 : 1;
        int currentY = origin.m_123342_() - directionSign * 5;
        int thickness = random.m_188503_(3) + 4;
        int height = ((TwoToneSpikeFeatureConfig)context.m_159778_()).heightRange.m_214085_(context.m_225041_());
        int slantAmountX = (random.m_188503_(6) + 5) * (random.m_188499_() ? -1 : 1);
        int slantAmountZ = (random.m_188503_(6) + 5) * (random.m_188499_() ? -1 : 1);
        if (random.m_188503_(4) == 0) {
            slantAmountX = 0;
        }
        if (random.m_188503_(4) == 0) {
            slantAmountZ = 0;
        }
        BlockState tipBlock = ((TwoToneSpikeFeatureConfig)context.m_159778_()).tipBlocks.get(context.m_225041_().m_188503_(((TwoToneSpikeFeatureConfig)context.m_159778_()).tipBlocks.size())).m_49966_();
        for (int layer = 0; layer < height; ++layer) {
            int currentZSlant;
            float currentThickness = thickness;
            int currentXSlant = slantAmountX == 0 ? 0 : layer / slantAmountX;
            int n = currentZSlant = slantAmountZ == 0 ? 0 : layer / slantAmountZ;
            if (layer == 0) {
                currentThickness -= 2.0f;
            } else if (layer == 1) {
                currentThickness -= 1.0f;
            } else if (layer == height - 1) {
                currentThickness = 0.5f;
                currentXSlant = slantAmountX == 0 ? 0 : (layer - 1) / slantAmountX;
                currentZSlant = slantAmountZ == 0 ? 0 : (layer - 1) / slantAmountZ;
            } else {
                currentThickness *= Math.max((float)(height - layer) / (float)height, 0.2f);
                currentThickness = Math.max(currentThickness, 1.1f);
            }
            int x = (int)(-currentThickness);
            while ((float)x <= currentThickness) {
                int z = (int)(-currentThickness);
                while ((float)z <= currentThickness) {
                    if ((float)(x * x + z * z) < currentThickness * currentThickness) {
                        blockpos$Mutable.m_122178_(origin.m_123341_() + x + currentXSlant, currentY, origin.m_123343_() + z + currentZSlant);
                        BlockState state2 = level.m_8055_((BlockPos)blockpos$Mutable);
                        if (!(state2.m_60815_() || state2.m_60713_(BzBlocks.CRYSTALLINE_FLOWER.get()) || state2.m_204336_(BzTags.AIR_LIKE))) {
                            BlockState newState = (double)layer > (double)((float)(height * 2) / 3.0f) + noiseGen.noise3_Classic(blockpos$Mutable.m_123341_(), blockpos$Mutable.m_123342_(), blockpos$Mutable.m_123343_()) * 2.0 ? tipBlock : attachedState;
                            level.m_7731_((BlockPos)blockpos$Mutable, newState, 3);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            currentY += directionSign;
        }
        return false;
    }
}

