/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.EnumSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DragonEnchantsCompat
implements ModCompat {
    private static final String END_STEP_ENCHANT_ATTACHED_TAG = "dragonenchants:end_step";
    private static final ResourceLocation END_STEP_RL = new ResourceLocation("dragonenchants", "end_step");

    public DragonEnchantsCompat() {
        ModChecker.dragonEnchantsPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.PROJECTILE_IMPACT_HANDLED);
    }

    @Override
    public InteractionResult isProjectileTeleportHandled(HitResult hitResult, Entity owner, Projectile projectile) {
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (projectile != null && projectile.getPersistentData().m_128471_(END_STEP_ENCHANT_ATTACHED_TAG) && GeneralUtils.isInTag(BuiltInRegistries.f_256876_, BzTags.ENCHANT_SPECIAL_DEDICATED_COMPAT, (Enchantment)BuiltInRegistries.f_256876_.m_7745_(END_STEP_RL))) {
                return EntityTeleportationHookup.runTeleportProjectileImpact((HitResult)blockHitResult, owner, (Entity)projectile) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }
}

