/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids.base;

import com.telepathicgrunt.the_bumblezone.fluids.base.FluidInfo;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public abstract class BzFlowingFluid
extends FlowingFluid {
    private final FluidInfo info;

    public BzFlowingFluid(FluidInfo info, boolean source) {
        this.info = info;
        if (source) {
            info.setSource(() -> this);
        } else {
            info.setFlowing(() -> this);
        }
    }

    public FluidInfo info() {
        return this.info;
    }

    public Fluid m_5615_() {
        return this.info.flowing();
    }

    public Fluid m_5613_() {
        return this.info.source();
    }

    protected boolean m_6760_(@NotNull Level level) {
        return this.info.properties().canConvertToSource();
    }

    protected void m_7456_(@NotNull LevelAccessor level, @NotNull BlockPos pos, BlockState blockState) {
        BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)blockState, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected int m_6719_(@NotNull LevelReader level) {
        return this.info.properties().slopeFindDistance();
    }

    protected int m_6713_(@NotNull LevelReader level) {
        return this.info.properties().dropOff();
    }

    public Item m_6859_() {
        BucketItem bucket = this.info.bucket();
        return bucket == null ? Items.f_41852_ : bucket;
    }

    protected boolean m_5486_(@NotNull FluidState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Fluid fluid, @NotNull Direction direction) {
        return Direction.DOWN == direction && !this.m_6212_(fluid);
    }

    public int m_6718_(@NotNull LevelReader level) {
        return this.info.properties().tickDelay();
    }

    protected float m_6752_() {
        return this.info.properties().explosionResistance();
    }

    protected BlockState m_5804_(@NotNull FluidState state) {
        LiquidBlock block = this.info.block();
        if (block == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)block.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(BzFlowingFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(@NotNull Fluid fluid) {
        return fluid == this.info.source() || fluid == this.info.flowing();
    }

    public Optional<SoundEvent> m_142520_() {
        SoundEvent event = this.info.properties().sounds().getOrDefault("bucket_fill", () -> null).get();
        return event == null ? Optional.of(SoundEvents.f_11781_) : Optional.of(event);
    }

    public static class Flowing
    extends BzFlowingFluid {
        public Flowing(FluidInfo info) {
            super(info, false);
            this.m_76142_((FluidState)((FluidState)this.f_76105_.m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(@NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public boolean m_7444_(@NotNull FluidState state) {
            return false;
        }

        public int m_7430_(@NotNull FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }
    }

    public static class Source
    extends BzFlowingFluid {
        public Source(FluidInfo info) {
            super(info, true);
        }

        public boolean m_7444_(@NotNull FluidState state) {
            return true;
        }

        public int m_7430_(@NotNull FluidState state) {
            return 8;
        }
    }
}

