/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.nethervinery.client.render.block.storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.nethervinery.client.render.block.storage.NetherStorageTypeRenderer;
import net.satisfy.nethervinery.core.block.NetherStorageBlock;
import net.satisfy.nethervinery.core.block.entity.NetherStorageBlockEntity;

public class NetherStorageBlockEntityRenderer
implements BlockEntityRenderer<NetherStorageBlockEntity> {
    private static final HashMap<ResourceLocation, NetherStorageTypeRenderer> STORAGE_TYPES = new HashMap();

    public static void registerStorageType(ResourceLocation name, NetherStorageTypeRenderer renderer) {
        STORAGE_TYPES.put(name, renderer);
    }

    public static NetherStorageTypeRenderer getRendererForId(ResourceLocation name) {
        return STORAGE_TYPES.get(name);
    }

    public void render(NetherStorageBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity == null || !entity.m_58898_()) {
            return;
        }
        BlockState state = entity.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof NetherStorageBlock) {
            NetherStorageBlock sB = (NetherStorageBlock)block;
            NonNullList<ItemStack> itemStacks = entity.getInventory();
            matrices.m_85836_();
            NetherStorageBlockEntityRenderer.applyBlockAngle(matrices, state, 180.0f);
            ResourceLocation type = sB.type();
            NetherStorageTypeRenderer renderer = NetherStorageBlockEntityRenderer.getRendererForId(type);
            if (renderer != null) {
                renderer.render(entity, matrices, vertexConsumers, itemStacks);
            }
            matrices.m_85849_();
        }
    }

    public static void applyBlockAngle(PoseStack matrices, BlockState state, float angleOffset) {
        float angle = ((Direction)state.m_61143_((Property)NetherStorageBlock.f_54117_)).m_122435_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        matrices.m_252781_(Axis.f_252436_.m_252977_(angleOffset - angle));
    }
}

