/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.mixin.quality_food;

import com.soytutta.mynethersdelight.common.block.PowderyCaneBlock;
import com.soytutta.mynethersdelight.common.block.PowderyCannonBlock;
import com.teamabnormals.neapolitan.common.block.MintBlock;
import com.teamabnormals.neapolitan.common.block.StrawberryBushBlock;
import de.cadentem.quality_food.compat.Compat;
import de.cadentem.quality_food.config.QualityConfig;
import de.cadentem.quality_food.core.Modification;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.util.QualityUtils;
import dev.xkmc.fruitsdelight.content.block.DoubleFruitBushBlock;
import dev.xkmc.fruitsdelight.content.block.FruitBushBlock;
import io.github.jasonsimpart.createdelightcore.content.util.EclipticSeasonsUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import net.satisfy.vinery.core.block.GrapeBush;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={QualityUtils.class})
public abstract class QualityFoodMixin {
    @Unique
    private static final RandomSource create_Delight_Core$RANDOM = RandomSource.m_216327_();

    @Inject(method={"applyQuality(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/state/BlockState;Lde/cadentem/quality_food/core/Quality;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void applyQualityMixin(ItemStack stack, BlockState state, Quality blockQuality, Player player, BlockState farmland, CallbackInfo ci) {
        TagKey crop = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("createdelight", "quality_crops"));
        if (QualityUtils.isRelevantCrop((BlockState)state) || state.m_204336_(crop)) {
            Quality selected = Quality.NONE;
            for (Quality quality : Quality.values()) {
                if (quality.level() == 0) continue;
                double chance = blockQuality.level() == 0 ? (double)QualityConfig.getChance((Quality)quality) : Mth.m_14008_((double)((double)QualityConfig.getChance((Quality)quality) * QualityConfig.calculateChance((Quality)quality, (double)QualityConfig.getWeight((Quality)blockQuality)) * QualityConfig.getWeight((Quality)Quality.DIAMOND)), (double)0.0, (double)1.0);
                chance = Modification.harvestOrSeedMultiplier((Quality)quality, (ItemStack)stack).apply(chance);
                chance = Modification.luck((Player)player).apply(chance);
                chance = Modification.farmland((BlockState)state, (BlockState)farmland).apply(chance);
                float growChance = 0.0f;
                if (player != null && !(player instanceof FakePlayer)) {
                    growChance = EclipticSeasonsUtil.getGrowChance(player.m_9236_(), player.m_20097_(), state) * 1.25f;
                }
                if (!((chance = Modification.multiplicative((float)growChance).apply(chance)) > 0.0) || !(chance >= create_Delight_Core$RANDOM.m_188500_())) continue;
                selected = quality;
            }
            QualityUtils.applyQuality((ItemStack)stack, (Quality)selected);
        } else if (QualityUtils.isValidQuality((Quality)blockQuality)) {
            QualityUtils.applyQuality((ItemStack)stack, (Quality)blockQuality);
        } else if (blockQuality != Quality.NONE_PLAYER_PLACED) {
            QualityUtils.applyQuality((ItemStack)stack, (Player)player);
        }
        ci.cancel();
    }

    @Inject(method={"isRelevantCrop"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void isRelevantCropMixin(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        Block block = state.m_60734_();
        if (Compat.isModLoaded((String)"neapolitan") && block instanceof StrawberryBushBlock) {
            StrawberryBushBlock strawberryBushBlock = (StrawberryBushBlock)block;
            cir.setReturnValue((Object)strawberryBushBlock.isMaxAge(state));
        } else if (Compat.isModLoaded((String)"neapolitan") && block instanceof MintBlock) {
            MintBlock mintBlock = (MintBlock)block;
            cir.setReturnValue((Object)mintBlock.isMaxAge(state));
        } else if (Compat.isModLoaded((String)"fruitsdelight") && (block instanceof FruitBushBlock || block instanceof DoubleFruitBushBlock)) {
            cir.setReturnValue((Object)((Integer)state.m_61143_((Property)BlockStateProperties.f_222999_) == 4 ? 1 : 0));
        } else if (Compat.isModLoaded((String)"vinery") && block instanceof GrapeBush || block instanceof SweetBerryBushBlock) {
            cir.setReturnValue((Object)((Integer)state.m_61143_((Property)BlockStateProperties.f_61407_) == 3 ? 1 : 0));
        } else if (block instanceof PowderyCaneBlock) {
            cir.setReturnValue((Object)((Boolean)state.m_61143_((Property)PowderyCaneBlock.LIT)));
        } else if (block instanceof PowderyCannonBlock) {
            cir.setReturnValue((Object)((Boolean)state.m_61143_((Property)PowderyCannonBlock.LIT)));
        }
    }
}

