/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.mixin.quality_food;

import de.cadentem.quality_food.capability.BlockData;
import de.cadentem.quality_food.config.QualityConfig;
import de.cadentem.quality_food.core.Modification;
import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockData.class}, remap=false)
public class BlockDataMixin {
    @Final
    @Shadow
    private Set<Quality> cookedQualities;
    @Final
    @Shadow
    private static RandomSource RANDOM;
    @Shadow
    private double qualityBonus;

    @Inject(method={"useQuality"}, at={@At(value="HEAD")}, cancellable=true)
    public void useQualityMixin(ItemStack stack, Player player, CallbackInfo ci) {
        Quality selected = null;
        for (Quality quality : this.cookedQualities) {
            if (selected != null && quality.level() >= selected.level()) continue;
            selected = quality;
        }
        if (selected != null) {
            QualityUtils.applyQuality((ItemStack)stack, (Quality)selected);
        } else {
            selected = Quality.NONE;
        }
        for (Quality quality : Quality.values()) {
            if (quality.level() == 0) continue;
            double chance = RANDOM.m_188500_();
            chance = Modification.luck((Player)player).apply(chance);
            chance = Modification.additive((float)((float)this.qualityBonus)).apply(chance);
            if (!(chance >= (double)(1.0f - QualityConfig.getChance((Quality)quality)))) continue;
            selected = quality;
        }
        QualityUtils.applyQuality((ItemStack)stack, (Quality)selected, (boolean)true);
        this.qualityBonus = 0.0;
        this.cookedQualities.clear();
        ci.cancel();
    }
}

