/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.data.lang;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import io.github.jasonsimpart.createdelightcore.data.CDCoreDatagen;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.StringUtils;

public class RegistrateCNLangProvider
extends LanguageProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> owner;

    public RegistrateCNLangProvider(AbstractRegistrate<?> owner, PackOutput packOutput) {
        super(packOutput, owner.getModid(), "zh_cn");
        this.owner = owner;
    }

    public LogicalSide getSide() {
        return LogicalSide.CLIENT;
    }

    public String m_6055_() {
        return "Lang (zh_cn)";
    }

    protected void addTranslations() {
        this.owner.genData(CDCoreDatagen.CNLANG, (RegistrateProvider)this);
    }

    public static final String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public <T> String getAutomaticName(NonNullSupplier<? extends T> sup, ResourceKey<Registry<T>> registry) {
        return RegistrateCNLangProvider.toEnglishName(((Registry)BuiltInRegistries.f_257047_.m_7745_(registry.m_135782_())).m_7981_(sup.get()).m_135815_());
    }

    public void addBlock(NonNullSupplier<? extends Block> block) {
        this.addBlock((Supplier)block, this.getAutomaticName(block, Registries.f_256747_));
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends Block> block, String tooltip) {
        this.addBlock(block);
        this.addTooltip(block, tooltip);
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends Block> block, String name, String tooltip) {
        this.addBlock((Supplier)block, name);
        this.addTooltip(block, tooltip);
    }

    public void addItem(NonNullSupplier<? extends Item> item) {
        this.addItem((Supplier)item, this.getAutomaticName(item, Registries.f_256913_));
    }

    public void addItemWithTooltip(NonNullSupplier<? extends Item> block, String name, List<@NonnullType String> tooltip) {
        this.addItem((Supplier)block, name);
        this.addTooltip(block, tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends ItemLike> item, String tooltip) {
        this.add(((ItemLike)item.get()).m_5456_().m_5524_() + ".desc", tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends ItemLike> item, List<@NonnullType String> tooltip) {
        for (int i = 0; i < tooltip.size(); ++i) {
            this.add(((ItemLike)item.get()).m_5456_().m_5524_() + ".desc." + i, tooltip.get(i));
        }
    }

    public void add(CreativeModeTab tab, String name) {
        ComponentContents contents = tab.m_40786_().m_214077_();
        if (!(contents instanceof TranslatableContents)) {
            throw new IllegalArgumentException("Creative tab does not have a translatable name: " + String.valueOf(tab.m_40786_()));
        }
        TranslatableContents lang = (TranslatableContents)contents;
        this.add(lang.m_237508_(), name);
    }

    public void addEntityType(NonNullSupplier<? extends EntityType<?>> entity) {
        this.addEntityType((Supplier)entity, this.getAutomaticName(entity, Registries.f_256939_));
    }

    public void add(String key, String value) {
        super.add(key, value);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return CompletableFuture.allOf(super.m_213708_(cache));
    }
}

