/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.compat.jade;

import fr.iglee42.cmr.cooler.SnowmanCoolerBlock;
import fr.iglee42.cmr.cooler.SnowmanCoolerBlockEntity;
import io.github.jasonsimpart.createdelightcore.compat.jade.CDPlugin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElementHelper;

public enum CoolerProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag compound = accessor.getServerData();
        SnowmanCoolerBlockEntity.FuelType activeFuel = SnowmanCoolerBlockEntity.FuelType.NONE;
        boolean isCreative = compound.m_128471_("isCreative");
        if (isCreative) {
            SnowmanCoolerBlock.HeatLevel heatLevel = SnowmanCoolerBlock.getHeatLevelOf((BlockState)accessor.getBlockState());
            if (heatLevel == SnowmanCoolerBlock.HeatLevel.FREEZING) {
                activeFuel = SnowmanCoolerBlockEntity.FuelType.SPECIAL;
            } else if (heatLevel != SnowmanCoolerBlock.HeatLevel.IDLE) {
                activeFuel = SnowmanCoolerBlockEntity.FuelType.NORMAL;
            }
        } else {
            activeFuel = SnowmanCoolerBlockEntity.FuelType.values()[compound.m_128451_("fuelLevel")];
        }
        if (activeFuel == SnowmanCoolerBlockEntity.FuelType.NONE) {
            return;
        }
        ItemStack item = new ItemStack((ItemLike)(activeFuel == SnowmanCoolerBlockEntity.FuelType.SPECIAL ? Items.f_42363_ : Items.f_42452_));
        tooltip.add(IElementHelper.get().smallItem(item));
        if (isCreative) {
            tooltip.append((Component)IThemeHelper.get().info((Object)Component.m_237115_((String)"jade.infinity")));
        } else {
            tooltip.append((Component)IThemeHelper.get().seconds(compound.m_128451_("burnTimeRemaining")));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        SnowmanCoolerBlockEntity cooler = (SnowmanCoolerBlockEntity)accessor.getBlockEntity();
        if (cooler.isCreative()) {
            data.m_128379_("isCreative", true);
        } else if (cooler.getActiveFuel() != SnowmanCoolerBlockEntity.FuelType.NONE) {
            data.m_128405_("fuelLevel", cooler.getActiveFuel().ordinal());
            data.m_128405_("burnTimeRemaining", cooler.getRemainingBurnTime());
        }
    }

    public ResourceLocation getUid() {
        return CDPlugin.SNOWMAN_COOLER;
    }
}

