/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.compat.cmr;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import fr.iglee42.cmr.cooler.SnowmanCoolerBlock;
import io.github.jasonsimpart.createdelightcore.mixin.cmr.SnowmanCoolerAccessor;
import io.github.jasonsimpart.createdelightcore.util.Triplet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class CoolerStomachHandler {
    public static Map<Fluid, Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>>> LIQUID_COOLER_FUEL_MAP = new HashMap<Fluid, Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>>>();

    public static boolean tick(SmartBlockEntity entity) {
        if (!(entity instanceof SnowmanCoolerAccessor)) {
            return false;
        }
        SnowmanCoolerAccessor coolerAccessor = (SnowmanCoolerAccessor)entity;
        SmartFluidTank stomach = (SmartFluidTank)entity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (stomach == null) {
            return false;
        }
        if (stomach.getFluid().getAmount() <= 0) {
            return false;
        }
        Triplet burnerProperty = (Triplet)LIQUID_COOLER_FUEL_MAP.get(stomach.getFluid().getFluid()).getSecond();
        if (burnerProperty == null) {
            return false;
        }
        boolean fluidSuperHeats = (Boolean)burnerProperty.getSecond();
        int mbConsuming = (Integer)burnerProperty.getThird();
        if (stomach.getFluid().getAmount() < mbConsuming) {
            stomach.getFluid().setAmount(0);
            return false;
        }
        if (fluidSuperHeats) {
            coolerAccessor.createdelightcore$invokeSetBlockHeat(SnowmanCoolerBlock.HeatLevel.FREEZING);
        } else {
            coolerAccessor.createdelightcore$invokeSetBlockHeat(SnowmanCoolerBlock.HeatLevel.COOLING);
        }
        int newBurnTime = coolerAccessor.createdelightcore$getRemainingBurnTime() + (Integer)burnerProperty.getFirst();
        if (newBurnTime > 10000) {
            return false;
        }
        coolerAccessor.createdelightcore$setRemainingBurnTime(newBurnTime);
        stomach.getFluid().shrink(mbConsuming);
        return true;
    }

    public static void tryUpdateFuel(@NotNull SmartBlockEntity entity, ItemStack itemStack, boolean forceOverflow, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        SmartFluidTank stomach = (SmartFluidTank)entity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (stomach == null) {
            return;
        }
        if (!itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return;
        }
        IFluidHandler handler = (IFluidHandler)itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (!stomach.getFluid().isEmpty() && handler.getFluidInTank(0).getFluid() != stomach.getFluid().getFluid()) {
            return;
        }
        if (handler.getTanks() != 1) {
            return;
        }
        FluidStack fluidStack = handler.getFluidInTank(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!LIQUID_COOLER_FUEL_MAP.containsKey(fluidStack.getFluid())) {
            return;
        }
        if (stomach.getFluid().getAmount() + fluidStack.getAmount() > stomach.getCapacity() && !forceOverflow) {
            return;
        }
        if (!simulate) {
            int amount = fluidStack.getAmount();
            FluidStack drained = handler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            stomach.fill(drained, IFluidHandler.FluidAction.EXECUTE);
        }
        cir.setReturnValue((Object)true);
    }
}

