/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.event;

import com.github.ysbbbbbb.kaleidoscopedoll.block.DollBlock;
import com.github.ysbbbbbb.kaleidoscopedoll.config.GeneralConfig;
import com.github.ysbbbbbb.kaleidoscopedoll.entity.DollEntity;
import com.github.ysbbbbbb.kaleidoscopedoll.event.ModRegisterEvent;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModEntities;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kaleidoscope_doll")
public class PhantomSpawnEvent {
    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Phantom)) {
            return;
        }
        Phantom phantom = (Phantom)entity;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!((Boolean)GeneralConfig.ENABLE_PHANTOM_DOLL_SPAWN.get()).booleanValue()) {
            return;
        }
        if (phantom.m_217043_().m_188500_() > (Double)GeneralConfig.PHANTOM_DOLL_SPAWN_CHANCE.get()) {
            return;
        }
        serverLevel.m_7654_().m_6937_((Runnable)new TickTask(5, () -> PhantomSpawnEvent.attachRandomDollToPhantom(phantom, serverLevel)));
    }

    private static void attachRandomDollToPhantom(Phantom phantom, ServerLevel level) {
        DollBlock randomBlock = PhantomSpawnEvent.getRandomDollBlock(level.f_46441_);
        if (randomBlock == null) {
            return;
        }
        DollEntity doll = new DollEntity((EntityType)ModEntities.DOLL.get(), (Level)level);
        doll.setDisplayBlockState(randomBlock.m_49966_());
        doll.m_6034_(phantom.m_20185_(), phantom.m_20186_() + 0.35, phantom.m_20189_());
        doll.m_146922_(phantom.m_146908_());
        doll.setDropFromPhantom(true);
        level.m_7967_((Entity)doll);
        doll.m_20329_((Entity)phantom);
    }

    private static DollBlock getRandomDollBlock(RandomSource random) {
        ArrayList dollBlocks = Lists.newArrayList(ModRegisterEvent.DOLL_BLOCKS.values());
        if (dollBlocks.isEmpty()) {
            return null;
        }
        return (DollBlock)((Object)dollBlocks.get(random.m_188503_(dollBlocks.size())));
    }
}

