/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.entity;

import com.github.ysbbbbbb.kaleidoscopedoll.client.gui.TweaksToolScreen;
import com.github.ysbbbbbb.kaleidoscopedoll.config.GeneralConfig;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModEntities;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopedoll.item.DollEntityItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;

public class DollEntity
extends Entity {
    private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE = SynchedEntityData.m_135353_(DollEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Vector3f> DATA_SCALE = SynchedEntityData.m_135353_(DollEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> DATA_TRANSLATION = SynchedEntityData.m_135353_(DollEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final String TAG_BLOCK_STATE = "doll_block_state";
    private static final String TAG_SCALE = "doll_scale";
    private static final String TAG_TRANSLATION = "doll_translation";
    private static final String TAG_DROP_FROM_PHANTOM = "drop_from_phantom";
    private static final String TAG_DROP_FROM_PHANTOM_TIME = "drop_from_phantom_time";
    private boolean inThrowing = false;
    private long bounceTime = 0L;
    private boolean dropFromPhantom = false;
    private int dropFromPhantomTick = 0;
    private int knockbackCount = 0;
    private int lastKnockbackTick = 0;

    public DollEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_6210_();
    }

    public DollEntity(Level level, double x, double y, double z, float yaw) {
        this((EntityType)ModEntities.DOLL.get(), level);
        this.m_6034_(x, y, z);
        this.m_146922_(yaw);
    }

    public void m_8119_() {
        double movementDelta;
        double frictionFactor;
        Level yRotSpeed2;
        super.m_8119_();
        if (this.dropFromPhantom && (Integer)GeneralConfig.PHANTOM_DOLL_EXIST_TICKS.get() > 0 && !(this.m_20202_() instanceof Phantom)) {
            ++this.dropFromPhantomTick;
            if (this.dropFromPhantomTick >= (Integer)GeneralConfig.PHANTOM_DOLL_EXIST_TICKS.get()) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 20, 0.2, 0.2, 0.2, 0.02);
                }
                this.m_146870_();
                return;
            }
        }
        if (this.m_20096_() || this.m_20069_() || this.m_20077_()) {
            this.inThrowing = false;
        } else if (this.m_20202_() == null && this.m_20197_().isEmpty() && this.m_20184_().m_82553_() > 0.5) {
            float rotationSpeed = Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)3.0f, (float)5.0f);
            float yRotSpeed2 = this.m_20148_().getLeastSignificantBits() % 2L == 0L ? rotationSpeed : -rotationSpeed;
            float xRotSpeed = this.m_20148_().getMostSignificantBits() % 2L == 0L ? rotationSpeed : -rotationSpeed;
            this.m_146922_((this.m_146908_() + yRotSpeed2) % 360.0f);
            this.m_146926_((this.m_146909_() + xRotSpeed) % 360.0f);
        }
        if (this.inThrowing && (yRotSpeed2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)yRotSpeed2;
            if (((Boolean)GeneralConfig.DOLL_THROW_PARTICLE_EFFECT.get()).booleanValue()) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175827_, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 3, 0.1, 0.1, 0.1, 0.2);
            }
        }
        if (this.f_19797_ > 2 && ((Boolean)GeneralConfig.DOLL_CAN_KNOCKBACK_ENTITIES.get()).booleanValue()) {
            this.checkCollisionKnockback();
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        FluidType fluidType = this.getMaxHeightFluidType();
        Vec3 movement = this.m_20184_();
        double fluidHeight = 1.0E-5;
        if (!fluidType.isAir() && this.getFluidTypeHeight(fluidType) > fluidHeight) {
            frictionFactor = 0.0;
            double floatingFactor = 0.0;
            if (((Boolean)GeneralConfig.DOLL_AFFECTED_BY_WATER.get()).booleanValue()) {
                frictionFactor = this.m_20077_() ? 0.9 : 0.95;
                floatingFactor = movement.f_82480_ < 0.06 ? 5.0E-4 : 0.0;
            }
            this.m_20334_(movement.f_82479_ * frictionFactor, movement.f_82480_ + floatingFactor, movement.f_82481_ * frictionFactor);
        } else if (!this.m_20068_()) {
            double gravity = (Boolean)GeneralConfig.DOLL_AFFECTED_BY_GRAVITY.get() != false ? 0.04 : 0.0;
            this.m_20256_(movement.m_82520_(0.0, -gravity, 0.0));
        }
        if (!this.m_20096_() || this.m_20184_().m_165925_() > 1.0E-5 || (this.f_19797_ + this.m_19879_()) % 4 == 0) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            frictionFactor = 0.98;
            if (this.m_20096_()) {
                BlockPos groundPos = this.m_20099_();
                frictionFactor = (double)this.m_9236_().m_8055_(groundPos).getFriction((LevelReader)this.m_9236_(), groundPos, (Entity)this) * 0.98;
            }
            this.m_20256_(this.m_20184_().m_82542_(frictionFactor, 0.98, frictionFactor));
            if (this.m_20096_()) {
                Vec3 bounceMovement = this.m_20184_();
                if (bounceMovement.f_82480_ < 0.0) {
                    this.m_20256_(bounceMovement.m_82542_(1.0, -0.5, 1.0));
                }
            }
        }
        if (((Boolean)GeneralConfig.DOLL_AFFECTED_BY_WATER.get()).booleanValue()) {
            this.f_19812_ |= this.m_20073_();
        }
        if (!this.m_9236_().f_46443_ && (movementDelta = this.m_20184_().m_82546_(movement).m_82556_()) > 0.01) {
            this.f_19812_ = true;
        }
    }

    public boolean canSurvives() {
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        return this.m_9236_().m_6249_((Entity)this, this.m_20191_(), e -> e instanceof DollEntity).isEmpty();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ModItems.TWEAKS_TOOL.get())) {
            if (this.m_9236_().f_46443_) {
                DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> TweaksToolScreen::openScreen);
            }
            return InteractionResult.SUCCESS;
        }
        long time = this.bounceTime - System.currentTimeMillis();
        if (time > 0L) {
            return InteractionResult.PASS;
        }
        this.bounceTime = System.currentTimeMillis() + 500L;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource randomSource = serverLevel.m_213780_();
            float pitch = 0.75f + randomSource.m_188501_() * 0.5f;
            this.m_5496_((SoundEvent)ModSounds.DUCK_TOY.get(), 1.0f, pitch);
            Vec3 notePos = this.m_20182_().m_82520_((double)(randomSource.m_188501_() / 2.0f) - 0.25, (double)(1.0f + randomSource.m_188501_() / 5.0f), (double)(randomSource.m_188501_() / 2.0f) - 0.25);
            float color = (float)randomSource.m_188503_(4) / 24.0f;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, notePos.m_7096_(), notePos.m_7098_(), notePos.m_7094_(), 0, (double)color, 0.0, 0.0, 1.0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected BlockPos m_20099_() {
        return this.m_216986_(0.999999f);
    }

    public boolean m_6783_(double pDistance) {
        return pDistance < 16384.0;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_213877_() && !this.m_9236_().f_46443_ && source.m_7640_() instanceof Player) {
            this.m_6074_();
            this.m_5834_();
            this.dropItem(source.m_7639_());
            return true;
        }
        return false;
    }

    private void dropItem(@Nullable Entity pBrokenEntity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12639_, 1.0f, 1.0f);
            if (pBrokenEntity instanceof Player) {
                Player player = (Player)pBrokenEntity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            ItemStack dollItem = DollEntityItem.createItemWithEntity(this);
            this.m_19983_(dollItem);
        }
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            this.m_146926_(-phantom.m_146909_());
        }
    }

    public double m_6049_() {
        if (this.m_20202_() instanceof Phantom) {
            return 0.125;
        }
        return 0.3125;
    }

    @Nullable
    public ItemStack m_142340_() {
        return DollEntityItem.createItemWithEntity(this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_BLOCK_STATE, (Object)Blocks.f_50016_.m_49966_());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)new Vector3f(1.0f));
        this.f_19804_.m_135372_(DATA_TRANSLATION, (Object)new Vector3f());
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_SCALE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128441_(TAG_BLOCK_STATE)) {
            HolderLookup lookup = this.m_9236_().m_246945_(Registries.f_256747_);
            this.setDisplayBlockState(NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)tag.m_128469_(TAG_BLOCK_STATE)));
        }
        if (tag.m_128441_(TAG_SCALE)) {
            this.setDisplayScale(this.readVector3f(tag.m_128469_(TAG_SCALE)));
        }
        if (tag.m_128441_(TAG_TRANSLATION)) {
            this.setDisplayTranslation(this.readVector3f(tag.m_128469_(TAG_TRANSLATION)));
        }
        if (tag.m_128441_(TAG_DROP_FROM_PHANTOM)) {
            this.dropFromPhantom = tag.m_128471_(TAG_DROP_FROM_PHANTOM);
        }
        if (tag.m_128441_(TAG_DROP_FROM_PHANTOM_TIME)) {
            this.dropFromPhantomTick = tag.m_128451_(TAG_DROP_FROM_PHANTOM_TIME);
        }
    }

    public void m_7380_(CompoundTag tag) {
        BlockState blockState = this.getDisplayBlockState();
        if (blockState != Blocks.f_50016_.m_49966_()) {
            tag.m_128365_(TAG_BLOCK_STATE, (Tag)NbtUtils.m_129202_((BlockState)blockState));
        }
        tag.m_128365_(TAG_SCALE, (Tag)this.writeVector3f(this.getDisplayScale()));
        tag.m_128365_(TAG_TRANSLATION, (Tag)this.writeVector3f(this.getDisplayTranslation()));
        tag.m_128379_(TAG_DROP_FROM_PHANTOM, this.dropFromPhantom);
        tag.m_128405_(TAG_DROP_FROM_PHANTOM_TIME, this.dropFromPhantomTick);
    }

    public void removePhantomRecord(CompoundTag tag) {
        tag.m_128473_(TAG_DROP_FROM_PHANTOM);
        tag.m_128473_(TAG_DROP_FROM_PHANTOM_TIME);
    }

    private Vector3f readVector3f(CompoundTag tag) {
        return new Vector3f(tag.m_128457_("x"), tag.m_128457_("y"), tag.m_128457_("z"));
    }

    private CompoundTag writeVector3f(Vector3f vector) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("x", vector.x);
        tag.m_128350_("y", vector.y);
        tag.m_128350_("z", vector.z);
        return tag;
    }

    public BlockState getDisplayBlockState() {
        return (BlockState)this.f_19804_.m_135370_(DATA_BLOCK_STATE);
    }

    public void setDisplayBlockState(BlockState blockState) {
        this.f_19804_.m_135381_(DATA_BLOCK_STATE, (Object)blockState);
    }

    public Vector3f getDisplayScale() {
        return (Vector3f)this.f_19804_.m_135370_(DATA_SCALE);
    }

    public void setDisplayScale(Vector3f scale) {
        this.f_19804_.m_276349_(DATA_SCALE, (Object)scale, true);
    }

    public Vector3f getDisplayTranslation() {
        return (Vector3f)this.f_19804_.m_135370_(DATA_TRANSLATION);
    }

    public void setDisplayTranslation(Vector3f translation) {
        this.f_19804_.m_276349_(DATA_TRANSLATION, (Object)translation, true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setInThrowing(boolean inThrowing) {
        this.inThrowing = inThrowing;
    }

    public long getBounceTime() {
        return this.bounceTime;
    }

    public void setDropFromPhantom(boolean dropFromPhantom) {
        this.dropFromPhantom = dropFromPhantom;
    }

    public void m_19915_(float yRot, float xRot) {
        super.m_19915_(yRot, xRot);
    }

    public EntityDimensions m_6972_(Pose pose) {
        Vector3f displayScale = this.getDisplayScale();
        EntityDimensions dimensions = super.m_6972_(pose);
        float width = Math.max(Math.abs(displayScale.x), Math.abs(displayScale.z));
        float height = Math.abs(displayScale.y);
        return dimensions.m_20390_(width, height);
    }

    private void checkCollisionKnockback() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 dollVelocity = this.m_20184_();
        double dollSpeed = dollVelocity.m_82553_();
        if (dollSpeed < 0.25) {
            return;
        }
        if (this.knockbackCount >= 5) {
            if (this.f_19797_ - this.lastKnockbackTick > 20) {
                this.knockbackCount = 0;
            }
            this.lastKnockbackTick = this.f_19797_;
            return;
        }
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.2), e -> e != this && e.m_6084_() && e.m_6087_())) {
            Vec3 knockbackDirection = this.m_20184_().m_82541_();
            double sizeNumber = 0.75 / (double)Math.max(this.m_20205_(), this.m_20206_());
            double knockbackStrength = Math.min(dollSpeed * 0.4, 1.0) * Math.min(sizeNumber * sizeNumber, 1.0) * (Double)GeneralConfig.DOLL_KNOCKBACK_FORCE.get();
            Vec3 knockbackVector = new Vec3(knockbackDirection.f_82479_ * knockbackStrength, Math.max(0.2, knockbackDirection.f_82480_ * knockbackStrength * 0.5), knockbackDirection.f_82481_ * knockbackStrength);
            Vec3 speed = entity.m_20184_().m_82549_(knockbackVector);
            double maxSpeed = Math.min(sizeNumber * sizeNumber, 1.0);
            if (speed.m_82553_() > maxSpeed) {
                speed = speed.m_82541_().m_82490_(maxSpeed);
            }
            entity.m_20256_(speed);
            entity.f_19812_ = true;
            ++this.knockbackCount;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 5, 0.2, 0.2, 0.2, 0.1);
        }
    }
}

