/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.client.render;

import com.github.ysbbbbbb.kaleidoscopedoll.entity.DollEntity;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopedoll.item.DollEntityItem;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.joml.Matrix4f;

public class DollEntityItemRender
extends BlockEntityWithoutLevelRenderer {
    private final Cache<ItemStack, ItemStack> dollCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private final ResourceLocation BG = new ResourceLocation("kaleidoscope_doll", "textures/item/doll_entity_item_bg.png");

    public DollEntityItemRender(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void m_108829_(ItemStack itemStackIn, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        ItemStack dollShowItem = (ItemStack)this.dollCache.getIfPresent((Object)itemStackIn);
        if (dollShowItem == null) {
            DollEntity entity = DollEntityItem.getDollEntity((Level)world, itemStackIn);
            Block displayBlock = entity.getDisplayBlockState().m_60734_();
            dollShowItem = displayBlock == Blocks.f_50016_ ? new ItemStack((ItemLike)ModItems.PURPLE_DOLL_GIFT_BOX.get()) : new ItemStack((ItemLike)displayBlock);
            this.dollCache.put((Object)itemStackIn, (Object)dollShowItem);
        }
        if (transformType == ItemDisplayContext.GUI) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.0);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BG);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            float size = 0.5f;
            bufferBuilder.m_252986_(matrix, -size, -size, -0.001f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, size, -size, -0.001f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, size, size, -0.001f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix, -size, size, -0.001f).m_7421_(0.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        if (transformType == ItemDisplayContext.GUI) {
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        }
        poseStack.m_85837_(0.5, 0.5, 0.5);
        itemRenderer.m_269128_(dollShowItem, transformType, combinedLight, combinedOverlay, poseStack, bufferSource, (Level)world, 0);
        poseStack.m_85849_();
    }
}

