/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.block.entity;

import com.github.ysbbbbbb.kaleidoscopedoll.datagen.TagItem;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModBlocks;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class DollMachineBlockEntity
extends BlockEntity {
    private static final String NBT_KEY_TIER = "Tier";
    private static final String NBT_KEY_AVAILABLE_DOLLS = "AvailableDolls";
    private Int2ObjectMap<List<ResourceLocation>> availableDolls = new Int2ObjectOpenHashMap();
    private int tier = 0;

    public DollMachineBlockEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public DollMachineBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlocks.DOLL_MACHINE_BE.get(), pos, state);
    }

    public void onTokensClicked(ItemStack itemStack, Level level) {
        if (itemStack.m_204117_(TagItem.TIER_0_MACHINE_TOKENS)) {
            this.tier = 0;
        } else if (itemStack.m_204117_(TagItem.TIER_1_MACHINE_TOKENS)) {
            this.tier = 1;
        } else if (itemStack.m_204117_(TagItem.TIER_2_MACHINE_TOKENS)) {
            this.tier = 2;
        }
        List list = (List)this.availableDolls.getOrDefault(this.tier, (Object)Lists.newArrayList());
        if (list.isEmpty()) {
            if (this.tier == 0) {
                this.shuffleDolls(TagItem.TIER_0_DOLLS, list);
            } else if (this.tier == 1) {
                this.shuffleDolls(TagItem.TIER_1_DOLLS, list);
            } else if (this.tier == 2) {
                this.shuffleDolls(TagItem.TIER_2_DOLLS, list);
            }
        }
        itemStack.m_41774_(1);
        this.m_6596_();
    }

    public ItemStack onFinishLottery() {
        ItemStack output = ItemStack.f_41583_;
        List list = (List)this.availableDolls.getOrDefault(this.tier, (Object)Lists.newArrayList());
        if (!list.isEmpty()) {
            ResourceLocation doll = (ResourceLocation)list.remove(0);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(doll);
            if (item != null) {
                output = new ItemStack((ItemLike)item);
            }
            this.availableDolls.put(this.tier, (Object)list);
            this.m_6596_();
        }
        return output;
    }

    private void shuffleDolls(TagKey<Item> tagKey, List<ResourceLocation> list) {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags == null) {
            return;
        }
        tags.getTag(tagKey).stream().forEach(tag -> {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey(tag);
            if (key != null) {
                list.add(key);
            }
        });
        Collections.shuffle(list);
        this.availableDolls.put(this.tier, list);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(NBT_KEY_TIER, this.tier);
        ListTag dollsTag = new ListTag();
        for (int i = 0; i < this.availableDolls.size(); ++i) {
            List dolls = (List)this.availableDolls.getOrDefault(i, (Object)Lists.newArrayList());
            ListTag listTag = new ListTag();
            for (ResourceLocation doll : dolls) {
                listTag.add((Object)StringTag.m_129297_((String)doll.toString()));
            }
            dollsTag.add((Object)listTag);
        }
        tag.m_128365_(NBT_KEY_AVAILABLE_DOLLS, (Tag)dollsTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(NBT_KEY_TIER)) {
            this.tier = tag.m_128451_(NBT_KEY_TIER);
        }
        this.availableDolls.clear();
        if (tag.m_128441_(NBT_KEY_AVAILABLE_DOLLS)) {
            ListTag dollsTag = tag.m_128437_(NBT_KEY_AVAILABLE_DOLLS, 10);
            for (int i = 0; i < dollsTag.size(); ++i) {
                ListTag listTag = dollsTag.m_128744_(i);
                List<ResourceLocation> dolls = listTag.stream().filter(nbt -> nbt instanceof StringTag).map(nbt -> new ResourceLocation(nbt.m_7916_())).toList();
                this.availableDolls.put(i, dolls);
            }
        }
    }

    public int getTier() {
        return this.tier;
    }
}

