/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.fml.ModList;
import someassemblyrequired.integration.create.CreateCompat;
import someassemblyrequired.integration.diet.DietCompat;
import someassemblyrequired.integration.farmersdelight.FarmersDelightCompat;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.registry.ModItems;

public class ModCompat {
    public static final String FARMERSDELIGHT = "farmersdelight";
    public static final String CREATE = "create";
    public static final String DIET = "diet";
    public static final String JEI = "jei";
    public static final String MINERS_DELIGHT = "miners_delight";
    public static final String SLICE_AND_DICE = "sliceanddice";
    public static final List<Potion> EXAMPLE_POTIONS = List.of(Potions.f_43600_, Potions.f_43601_, Potions.f_43602_, Potions.f_43603_, Potions.f_43605_, Potions.f_43607_, Potions.f_43610_, Potions.f_43612_, Potions.f_43615_, Potions.f_43618_, Potions.f_43621_, Potions.f_43623_, Potions.f_43582_, Potions.f_43584_, Potions.f_43587_, Potions.f_43590_, Potions.f_43593_, Potions.f_43596_);

    public static void setup() {
        if (ModCompat.isFarmersDelightLoaded()) {
            FarmersDelightCompat.setup();
        }
        if (ModCompat.isCreateLoaded()) {
            CreateCompat.setup();
        }
        if (ModCompat.isDietLoaded()) {
            DietCompat.setup();
        }
    }

    public static boolean isFarmersDelightLoaded() {
        return ModCompat.isLoaded(FARMERSDELIGHT);
    }

    public static boolean isCreateLoaded() {
        return ModCompat.isLoaded(CREATE);
    }

    public static boolean isDietLoaded() {
        return ModCompat.isLoaded(DIET);
    }

    public static boolean isJEILoaded() {
        return ModCompat.isLoaded(JEI);
    }

    public static boolean isMinersDelightLoaded() {
        return ModCompat.isLoaded(MINERS_DELIGHT);
    }

    private static boolean isLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static void gatherCreativeTabSandwiches(Consumer<ItemStack> consumer) {
        if (ModCompat.isFarmersDelightLoaded()) {
            FarmersDelightCompat.populateCreativeTab(consumer);
        }
    }

    public static void gatherJEISandwiches(Consumer<ItemStack> consumer) {
        if (ModCompat.isFarmersDelightLoaded()) {
            FarmersDelightCompat.populateJEI(consumer);
        }
        if (ModCompat.isCreateLoaded()) {
            CreateCompat.populateJEI(consumer);
        }
        EXAMPLE_POTIONS.stream().map(SandwichItem::makeSandwich).forEach(consumer);
        Stream.of((Item)ModItems.APPLE_SLICES.get(), (Item)ModItems.CHOPPED_CARROT.get(), (Item)ModItems.CHOPPED_BEETROOT.get(), (Item)ModItems.TOMATO_SLICES.get()).map(xva$0 -> SandwichItem.makeSandwich(xva$0)).forEach(consumer);
    }
}

