/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.box;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageDestroyPacket;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.chute.ChuteBlock;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;

public class PackageEntity
extends LivingEntity
implements IEntityAdditionalSpawnData {
    private Entity originalEntity;
    public ItemStack box;
    public int insertionDelay;
    public Vec3 clientPosition;
    public Vec3 vec2 = Vec3.f_82478_;
    public Vec3 vec3 = Vec3.f_82478_;
    public WeakReference<Player> tossedBy = new WeakReference<Object>(null);

    public PackageEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.box = ItemStack.f_41583_;
        this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
        this.m_5616_(this.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.insertionDelay = 30;
    }

    public PackageEntity(Level worldIn, double x, double y, double z) {
        this((EntityType)AllEntityTypes.PACKAGE.get(), worldIn);
        this.m_6034_(x, y, z);
        this.m_6210_();
    }

    public static PackageEntity fromDroppedItem(Level world, Entity originalEntity, ItemStack itemstack) {
        PackageEntity packageEntity = (PackageEntity)((EntityType)AllEntityTypes.PACKAGE.get()).m_20615_(world);
        Vec3 position = originalEntity.m_20182_();
        packageEntity.m_146884_(position);
        packageEntity.setBox(itemstack);
        packageEntity.m_20256_(originalEntity.m_20184_().m_82490_(1.5));
        packageEntity.originalEntity = originalEntity;
        if (world != null && !world.f_46443_ && ChuteBlock.isChute(world.m_8055_(BlockPos.m_274561_((double)position.f_82479_, (double)(position.f_82480_ + 0.5), (double)position.f_82481_)))) {
            packageEntity.m_146922_((int)packageEntity.m_146908_() / 90 * 90);
        }
        return packageEntity;
    }

    public static PackageEntity fromItemStack(Level world, Vec3 position, ItemStack itemstack) {
        PackageEntity packageEntity = (PackageEntity)((EntityType)AllEntityTypes.PACKAGE.get()).m_20615_(world);
        packageEntity.m_146884_(position);
        packageEntity.setBox(itemstack);
        return packageEntity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.box.m_41777_();
    }

    public static AttributeSupplier.Builder createPackageAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> boxBuilder = builder;
        return boxBuilder.setCustomClientFactory(PackageEntity::spawn).m_20699_(1.0f, 1.0f);
    }

    public void m_7023_(Vec3 p_213352_1_) {
        super.m_7023_(p_213352_1_);
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (this.m_20184_().m_82553_() < 0.0078125) {
            return;
        }
        if (this.f_19797_ >= 20) {
            return;
        }
        Vec3 motion = this.m_20184_().m_82490_(0.75);
        AABB bb = this.m_20191_();
        List entityStream = this.m_9236_().m_183134_((Entity)this, bb.m_82369_(motion));
        motion = PackageEntity.m_198894_((Entity)this, (Vec3)motion, (AABB)bb, (Level)this.m_9236_(), (List)entityStream);
        Vec3 clientPos = this.m_20182_().m_82549_(motion);
        if (this.f_20903_ != 0) {
            clientPos = VecHelper.lerp((float)Math.min(1.0f, (float)this.f_19797_ / 20.0f), (Vec3)clientPos, (Vec3)new Vec3(this.f_20904_, this.f_20905_, this.f_20906_));
        }
        if (this.f_19797_ < 5) {
            this.m_6034_(clientPos.f_82479_, clientPos.f_82480_, clientPos.f_82481_);
        }
        if (this.f_19797_ < 20) {
            this.m_6453_(clientPos.f_82479_, clientPos.f_82480_, clientPos.f_82481_, this.m_146908_(), this.m_146909_(), this.f_20903_ == 0 ? 3 : this.f_20903_, true);
        }
    }

    public void m_6001_(double x, double y, double z) {
        this.m_20256_(this.m_20184_().m_82520_(x, y, z).m_82490_(0.5));
    }

    public String getAddress() {
        return this.box.m_41783_().m_128461_("Address");
    }

    public void m_8119_() {
        if (this.f_19803_) {
            this.verifyInitialEntity();
            this.originalEntity = null;
        }
        if (this.m_9236_() instanceof PonderLevel) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.06, 0.0));
            if (this.m_20182_().f_82480_ < 0.125) {
                this.m_146870_();
            }
        }
        this.insertionDelay = Math.min(this.insertionDelay + 1, 30);
        super.m_8119_();
        if (!PackageItem.isPackage(this.box)) {
            this.m_146870_();
        }
    }

    protected void verifyInitialEntity() {
        Entity entity = this.originalEntity;
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        CompoundTag nbt = new CompoundTag();
        itemEntity.m_7380_(nbt);
        if (nbt.m_128451_("PickupDelay") != Short.MAX_VALUE) {
            return;
        }
        this.m_146870_();
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.box == null) {
            return super.m_6972_(pPose);
        }
        return new EntityDimensions(PackageItem.getWidth(this.box), PackageItem.getHeight(this.box), true);
    }

    public static PackageEntity spawn(PlayMessages.SpawnEntity spawnEntity, Level world) {
        PackageEntity packageEntity = new PackageEntity(world, spawnEntity.getPosX(), spawnEntity.getPosY(), spawnEntity.getPosZ());
        packageEntity.m_20334_(spawnEntity.getVelX(), spawnEntity.getVelY(), spawnEntity.getVelZ());
        packageEntity.clientPosition = packageEntity.m_20182_();
        return packageEntity;
    }

    public ItemStack getBox() {
        return this.box;
    }

    public static boolean centerPackage(Entity entity, Vec3 target) {
        if (!(entity instanceof PackageEntity)) {
            return true;
        }
        PackageEntity packageEntity = (PackageEntity)entity;
        return packageEntity.decreaseInsertionTimer(target);
    }

    public boolean decreaseInsertionTimer(@Nullable Vec3 targetSpot) {
        if (targetSpot != null) {
            this.m_20256_(this.m_20184_().m_82490_(0.75).m_82542_(1.0, 0.25, 1.0));
            Vec3 pos = this.m_20182_().m_82549_(targetSpot.m_82546_(this.m_20182_()).m_82490_((double)0.2f));
            this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            float yawTarget = (int)this.m_146908_() / 90 * 90;
            this.m_146922_(AngleHelper.angleLerp((double)0.5, (double)this.m_146908_(), (double)yawTarget));
        }
        this.insertionDelay = Math.max(this.insertionDelay - 3, 0);
        return this.insertionDelay == 0;
    }

    public void setBox(ItemStack box) {
        this.box = box.m_41777_();
        this.m_6210_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_7337_(Entity pEntity) {
        return pEntity instanceof PackageEntity && pEntity.m_20191_().f_82292_ < this.m_20191_().f_82289_ + 0.125;
    }

    public boolean m_5829_() {
        return false;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (!pPlayer.m_21120_(pHand).m_41619_()) {
            return super.m_6096_(pPlayer, pHand);
        }
        if (pPlayer.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        pPlayer.m_21008_(pHand, this.box);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 0.75f + this.m_9236_().f_46441_.m_188501_());
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    public void m_7334_(Entity entityIn) {
        boolean isOtherPackage = entityIn instanceof PackageEntity;
        if (!isOtherPackage && this.tossedBy.get() != null) {
            this.tossedBy = new WeakReference<Object>(null);
        }
        if (isOtherPackage) {
            if (entityIn.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(entityIn);
            }
        } else if (entityIn.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(entityIn);
        }
    }

    public double m_6048_() {
        return this.m_6972_((Pose)this.m_20089_()).f_20378_;
    }

    protected void m_6763_(BlockState state) {
        super.m_6763_(state);
        if (!this.m_6084_()) {
            return;
        }
        if (state.m_60734_() == Blocks.f_49990_) {
            this.destroy(this.m_269291_().m_269063_());
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean shotCanPierce;
        if (!ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.m_9236_().f_46443_ || !this.m_6084_()) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return false;
        }
        if (!this.box.m_41720_().m_41386_(source)) {
            return false;
        }
        if (source.equals(this.m_269291_().m_269318_()) && (this.m_20159_() || this.insertionDelay < 20)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268549_)) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            this.destroy(source);
            this.m_142687_(Entity.RemovalReason.KILLED);
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            if (this.m_6060_()) {
                this.takeDamage(source, 0.15f);
            } else {
                this.m_20254_(5);
            }
            return false;
        }
        boolean wasShot = source.m_7640_() instanceof AbstractArrow;
        boolean bl = shotCanPierce = wasShot && ((AbstractArrow)source.m_7640_()).m_36796_() > 0;
        if (source.m_7639_() instanceof Player && !((Player)source.m_7639_()).m_150110_().f_35938_) {
            return false;
        }
        this.destroy(source);
        this.m_142687_(Entity.RemovalReason.KILLED);
        return shotCanPierce;
    }

    private void takeDamage(DamageSource source, float amount) {
        float hp = this.m_21223_();
        if ((hp -= amount) <= 0.5f) {
            this.destroy(source);
            this.m_142687_(Entity.RemovalReason.KILLED);
        } else {
            this.m_21153_(hp);
        }
    }

    private void destroy(DamageSource source) {
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new PackageDestroyPacket(this.m_20191_().m_82399_(), this.box));
        AllSoundEvents.PACKAGE_POP.playOnServer(this.m_9236_(), (Vec3i)this.m_20183_());
        this.m_6668_(source);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        super.m_6668_(pDamageSource);
        ItemStackHandler contents = PackageItem.getContents(this.box);
        for (int i = 0; i < contents.getSlots(); ++i) {
            ItemStack itemstack = contents.getStackInSlot(i);
            Item item = itemstack.m_41720_();
            if (item instanceof SpawnEggItem) {
                SpawnEggItem sei = (SpawnEggItem)item;
                item = this.m_9236_();
                if (item instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)item;
                    EntityType entitytype = sei.m_43228_(itemstack.m_41783_());
                    Entity entity = entitytype.m_20592_(sl, itemstack, null, this.m_20183_(), MobSpawnType.SPAWN_EGG, false, false);
                    if (entity != null) {
                        itemstack.m_41774_(1);
                    }
                }
            }
            if (itemstack.m_41619_()) continue;
            ItemEntity entityIn = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemstack);
            this.m_9236_().m_7967_((Entity)entityIn);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.box = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Box"));
        this.m_6210_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Box", (Tag)this.box.serializeNBT());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        if (pSlot == EquipmentSlot.MAINHAND) {
            return this.getBox();
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        if (pSlot == EquipmentSlot.MAINHAND) {
            this.setBox(pStack);
        }
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public InteractionHand m_7655_() {
        return InteractionHand.MAIN_HAND;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.getBox());
        Vec3 motion = this.m_20184_();
        buffer.writeFloat((float)motion.f_82479_);
        buffer.writeFloat((float)motion.f_82480_);
        buffer.writeFloat((float)motion.f_82481_);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setBox(additionalData.m_130267_());
        this.m_20334_(additionalData.readFloat(), additionalData.readFloat(), additionalData.readFloat());
    }

    public float m_6100_() {
        return 1.5f;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_256739_, SoundEvents.f_256739_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5825_() {
        return this.box.m_41720_().m_41475_() || super.m_5825_();
    }
}

